/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.render;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.auto.service.AutoService;
import org.apache.jmeter.extractor.json.jmespath.JMESPathCache;
import org.apache.jmeter.extractor.json.render.AbstractRenderAsJsonRenderer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={ResultRenderer.class})
public class RenderAsJmesPathRenderer
extends AbstractRenderAsJsonRenderer {
    private static final Logger log = LoggerFactory.getLogger(RenderAsJmesPathRenderer.class);
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().enable(new StreamReadFeature[]{StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION})).build();

    @Override
    protected String getTabLabel() {
        return JMeterUtils.getResString((String)"jmespath_tester_title");
    }

    @Override
    protected String getTestButtonLabel() {
        return JMeterUtils.getResString((String)"jmespath_tester_button_test");
    }

    @Override
    protected String getExpressionLabel() {
        return JMeterUtils.getResString((String)"jmespath_tester_field");
    }

    @Override
    protected String process(String textToParse) {
        String expression = this.getExpression();
        try {
            JsonNode actualObj = (JsonNode)OBJECT_MAPPER.readValue(textToParse, JsonNode.class);
            JsonNode result = (JsonNode)JMESPathCache.getInstance().get(expression).search((Object)actualObj);
            if (result.isNull()) {
                return "NO MATCH";
            }
            if (result.isArray()) {
                StringBuilder builder = new StringBuilder();
                int i = 0;
                for (JsonNode element : (ArrayNode)result) {
                    builder.append("Result[").append(i++).append("]=").append(RenderAsJmesPathRenderer.writeJsonNode(OBJECT_MAPPER, element)).append("\n");
                }
                return builder.toString();
            }
            return "Result[0]=" + RenderAsJmesPathRenderer.writeJsonNode(OBJECT_MAPPER, result) + "\n";
        }
        catch (Exception e) {
            log.debug("Exception extracting from '{}' with expression '{}'", (Object)textToParse, (Object)expression);
            return "Exception: " + e.getMessage();
        }
    }

    private static String writeJsonNode(ObjectMapper mapper, JsonNode element) throws JsonProcessingException {
        if (element.isTextual()) {
            return element.asText();
        }
        return mapper.writeValueAsString((Object)element);
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"jmespath_renderer");
    }
}

