/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.jmeter.protocol.http.proxy.DefaultSamplerCreator;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.proxy.SamplerCreator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.LogAndIgnoreServiceLoadExceptionHandler;
import org.apache.jorphan.reflect.ServiceLoadExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplerCreatorFactory {
    private static final Logger log = LoggerFactory.getLogger(SamplerCreatorFactory.class);
    private static final SamplerCreator DEFAULT_SAMPLER_CREATOR = new DefaultSamplerCreator();
    private final Map<String, SamplerCreator> samplerCreatorMap = new HashMap<String, SamplerCreator>();

    public SamplerCreatorFactory() {
        this.init();
    }

    public void setCounter(int value) {
        DEFAULT_SAMPLER_CREATOR.setCounter(value);
        for (SamplerCreator samplerCreator : this.samplerCreatorMap.values()) {
            samplerCreator.setCounter(value);
        }
    }

    private void init() {
        for (SamplerCreator creator : JMeterUtils.loadServicesAndScanJars(SamplerCreator.class, ServiceLoader.load(SamplerCreator.class), (ClassLoader)Thread.currentThread().getContextClassLoader(), (ServiceLoadExceptionHandler)new LogAndIgnoreServiceLoadExceptionHandler(log))) {
            try {
                String[] contentTypes;
                for (String contentType : contentTypes = creator.getManagedContentTypes()) {
                    log.debug("Registering samplerCreator {} for content type:{}", (Object)creator.getClass().getName(), (Object)contentType);
                    SamplerCreator oldSamplerCreator = this.samplerCreatorMap.put(contentType, creator);
                    if (oldSamplerCreator == null) continue;
                    log.warn("A sampler creator was already registered for:{}, class:{}, it will be replaced", (Object)contentType, oldSamplerCreator.getClass());
                }
            }
            catch (Exception e) {
                log.error("Exception registering {} with implementation:{}", new Object[]{SamplerCreator.class.getName(), creator.getClass(), e});
            }
        }
    }

    public SamplerCreator getSamplerCreator(HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) {
        SamplerCreator creator = this.samplerCreatorMap.get(request.getContentType());
        if (creator == null) {
            return DEFAULT_SAMPLER_CREATOR;
        }
        return creator;
    }
}

