/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.BinaryUtils;
import eu.luminis.jmeter.wssampler.ComparisonType;
import eu.luminis.jmeter.wssampler.FrameFilter;
import eu.luminis.websocket.BinaryFrame;
import eu.luminis.websocket.Frame;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class BinaryFrameFilter
extends FrameFilter {
    private static Logger log = LoggingManager.getLoggerForClass();
    ComparisonType filterType;
    Integer matchPosition;
    byte[] matchValue;

    public BinaryFrameFilter() {
        this.filterType = ComparisonType.IsPlain;
    }

    public BinaryFrameFilter(ComparisonType type) {
        this.filterType = type;
        this.setComparisonType(type);
    }

    @Override
    protected void prepareFilter() {
        this.matchValue = new byte[0];
        this.filterType = this.getComparisonType();
        switch (this.filterType) {
            case Contains: 
            case NotContains: {
                this.matchPosition = this.convertToInt(this.getMatchPosition());
            }
            case Equals: 
            case NotEquals: 
            case StartsWith: 
            case NotStartsWith: 
            case EndsWith: 
            case NotEndsWith: {
                try {
                    this.matchValue = BinaryUtils.parseBinaryString(this.getMatchValue());
                    if (this.matchValue.length != 0) break;
                    log.error("Binary filter '" + this.getName() + "' is missing match value; will filter nothing!");
                    break;
                }
                catch (NumberFormatException noNumber) {
                    log.error("Binary filter '" + this.getName() + "' will filter nothing, because it has an invalid (non binary) match value: '" + this.getMatchValue() + "'");
                }
            }
        }
    }

    private Integer convertToInt(String matchPosition) {
        try {
            return Integer.parseInt(matchPosition);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    protected boolean matchesFilter(Frame frame) {
        if (frame.isBinary()) {
            BinaryFrame receivedFrame = (BinaryFrame)frame;
            byte[] frameBytes = receivedFrame.getBinaryData();
            switch (this.filterType) {
                case IsPlain: {
                    return true;
                }
                case Equals: 
                case NotEquals: {
                    boolean equal;
                    boolean bl = equal = frameBytes.length == this.matchValue.length && BinaryFrameFilter.equalBytes(frameBytes, 0, this.matchValue, 0, this.matchValue.length);
                    return this.filterType == ComparisonType.Equals ? equal : !equal;
                }
                case Contains: 
                case NotContains: {
                    if (this.matchPosition != null) {
                        boolean contains = this.matchValue.length > 0 && this.matchPosition + this.matchValue.length <= frameBytes.length ? BinaryFrameFilter.equalBytes(frameBytes, this.matchPosition, this.matchValue, 0, this.matchValue.length) : false;
                        return this.filterType == ComparisonType.Contains ? contains : !contains;
                    }
                    boolean contains = BinaryUtils.contains(frameBytes, this.matchValue);
                    return this.filterType == ComparisonType.Contains ? contains : !contains;
                }
                case StartsWith: 
                case NotStartsWith: {
                    boolean startsWith = BinaryFrameFilter.equalBytes(frameBytes, 0, this.matchValue, 0, this.matchValue.length);
                    return this.filterType == ComparisonType.StartsWith ? startsWith : !startsWith;
                }
                case EndsWith: 
                case NotEndsWith: {
                    boolean endsWith = BinaryFrameFilter.equalBytes(frameBytes, Math.max(0, frameBytes.length - this.matchValue.length), this.matchValue, 0, this.matchValue.length);
                    return this.filterType == ComparisonType.EndsWith ? endsWith : !endsWith;
                }
            }
            throw new RuntimeException("unknown comparison type");
        }
        return false;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    public String toString() {
        return "Binary Frame Filter '" + this.getName() + "'";
    }

    static boolean equalBytes(byte[] frameBytes, int matchPosition, byte[] matchValue, int valuePosition, int length) {
        if (matchPosition + length > frameBytes.length || valuePosition + length > matchValue.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (frameBytes[matchPosition + i] == matchValue[valuePosition + i]) continue;
            return false;
        }
        return true;
    }

    public ComparisonType getComparisonType() {
        return ComparisonType.valueOf(this.getPropertyAsString("comparisonType", "IsPlain"));
    }

    public void setComparisonType(ComparisonType type) {
        this.setProperty("comparisonType", type.toString());
    }

    public String getMatchPosition() {
        return this.getPropertyAsString("matchPosition");
    }

    public void setMatchPosition(String value) {
        this.setProperty("matchPosition", value);
    }

    public String getMatchValue() {
        return this.getPropertyAsString("matchValue");
    }

    public void setMatchValue(String value) {
        this.setProperty("matchValue", value);
    }
}

