/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.FrameFilter;
import eu.luminis.jmeter.wssampler.WebsocketSampler;
import eu.luminis.websocket.CloseFrame;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.UnexpectedFrameException;
import eu.luminis.websocket.WebSocketClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CloseWebSocketSampler
extends WebsocketSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();

    @Override
    protected WebSocketClient prepareWebSocketClient(SampleResult result) {
        WebSocketClient wsClient = (WebSocketClient)threadLocalCachedConnection.get();
        if (wsClient == null) {
            log.warn("Sampler '" + this.getName() + "': there is no connection; nothing to close.");
            result.setSamplerData("No request sent.");
            result.setResponseMessage("No connection; nothing to close.");
            return null;
        }
        return wsClient;
    }

    @Override
    protected Frame doSample(WebSocketClient wsClient, SampleResult result) throws IOException, UnexpectedFrameException {
        int closeStatus = Integer.parseInt(this.getStatusCode());
        String reason = "sampler requested close";
        result.setSamplerData("Requested connection close with status " + closeStatus + " and reason '" + reason + "'.");
        Frame frameSent = wsClient.sendClose(closeStatus, reason);
        result.setSentBytes((long)frameSent.getSize());
        Frame receivedFrame = null;
        receivedFrame = !this.frameFilters.isEmpty() ? ((FrameFilter)((Object)this.frameFilters.get(0))).receiveFrame(this.frameFilters.subList(1, this.frameFilters.size()), wsClient, this.readTimeout, result) : wsClient.receiveFrame(this.readTimeout);
        if (receivedFrame.isClose()) {
            return receivedFrame;
        }
        throw new UnexpectedFrameException(receivedFrame);
    }

    @Override
    protected void postProcessResponse(Frame response, SampleResult result) {
        CloseFrame frame = (CloseFrame)response;
        result.setResponseMessage("Connection closed" + (frame.getCloseReason() != null ? "; close reason: '" + frame.getCloseReason() + "'." : "."));
        result.setResponseCode(frame.getCloseStatus() != null ? frame.getCloseStatus().toString() : "");
        result.setResponseData("" + (frame.getCloseStatus() != null ? frame.getCloseStatus() : "") + (frame.getCloseReason() != null ? ": " + frame.getCloseReason() : ""), StandardCharsets.UTF_8.name());
        result.setDataType("text");
    }

    @Override
    protected void handleUnexpectedFrameException(UnexpectedFrameException e, SampleResult result) {
        log.debug("Sampler '" + this.getName() + "': close request was not answered with close response, but " + e.getReceivedFrame());
        result.setResponseCode("WebSocket error: unsuccesful close.");
        result.setResponseMessage("WebSocket error: received not a close frame, but " + e.getReceivedFrame());
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected String validateArguments() {
        String errorMsg = null;
        errorMsg = this.validateReadTimeout(this.getReadTimeout());
        return errorMsg;
    }

    public String getStatusCode() {
        return this.getPropertyAsString("statusCode", "1000");
    }

    public void setStatusCode(String status) {
        this.setProperty("statusCode", status);
    }

    @Override
    public void setTLS(boolean value) {
        throw new UnsupportedOperationException();
    }
}

