/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.OpenWebSocketSampler;
import eu.luminis.jmeter.wssampler.OpenWebSocketSamplerGuiPanel;
import java.awt.BorderLayout;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;

public class OpenWebSocketSamplerGui
extends AbstractSamplerGui {
    private OpenWebSocketSamplerGuiPanel settingsPanel;

    public OpenWebSocketSamplerGui() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.settingsPanel = new OpenWebSocketSamplerGuiPanel();
        this.add(this.settingsPanel, "Center");
    }

    public void clearGui() {
        super.clearGui();
        this.settingsPanel.clearGui();
    }

    public String getStaticLabel() {
        return "WebSocket Open Connection";
    }

    public String getLabelResource() {
        return null;
    }

    public TestElement createTestElement() {
        OpenWebSocketSampler element = new OpenWebSocketSampler();
        this.configureTestElement((TestElement)element);
        return element;
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof OpenWebSocketSampler) {
            OpenWebSocketSampler sampler = (OpenWebSocketSampler)element;
            this.settingsPanel.setTLS(sampler.getTLS());
            this.settingsPanel.serverField.setText(sampler.getServer());
            this.settingsPanel.portField.setText(sampler.getPort());
            this.settingsPanel.pathField.setText(sampler.getPath());
            this.settingsPanel.connectionTimeoutField.setText(sampler.getConnectTimeout());
            this.settingsPanel.readTimeoutField.setText(sampler.getReadTimeout());
        }
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        if (element instanceof OpenWebSocketSampler) {
            OpenWebSocketSampler sampler = (OpenWebSocketSampler)element;
            sampler.setTLS(this.settingsPanel.getTLS());
            sampler.setServer(this.settingsPanel.serverField.getText());
            sampler.setPort(this.settingsPanel.portField.getText());
            sampler.setPath(this.settingsPanel.pathField.getText());
            sampler.setConnectTimeout(this.settingsPanel.connectionTimeoutField.getText());
            sampler.setReadTimeout(this.settingsPanel.readTimeoutField.getText());
        }
    }
}

