/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.FrameFilter;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.PingFrame;
import eu.luminis.websocket.WebSocketClient;
import java.io.IOException;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class PingFrameFilter
extends FrameFilter {
    private static Logger log = LoggingManager.getLoggerForClass();

    @Override
    protected boolean matchesFilter(Frame receivedFrame) {
        switch (this.getFilterType()) {
            case FilterAll: {
                return receivedFrame.isPing() || receivedFrame.isPong();
            }
            case FilterPingOnly: {
                return receivedFrame.isPing();
            }
            case FilterPongOnly: {
                return receivedFrame.isPong();
            }
        }
        throw new RuntimeException("Unknown filter type");
    }

    @Override
    public String toString() {
        return "Ping Frame Filter '" + this.getName() + "'";
    }

    @Override
    protected Frame performReplyAction(WebSocketClient wsClient, Frame receivedFrame) throws IOException {
        if (receivedFrame.isPing() && this.getReplyToPing()) {
            log.debug("Automatically replying to ping with a pong.");
            return wsClient.sendPongFrame(((PingFrame)receivedFrame).getData());
        }
        return null;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    public boolean getReplyToPing() {
        return this.getPropertyAsBoolean("replyToPing");
    }

    public void setReplyToPing(boolean value) {
        this.setProperty("replyToPing", value);
    }

    public PingFilterType getFilterType() {
        return PingFilterType.valueOf(this.getPropertyAsString("filterType", "FilterAll"));
    }

    public void setFilterType(PingFilterType type) {
        this.setProperty("filterType", type.toString());
    }

    public static enum PingFilterType {
        FilterAll,
        FilterPingOnly,
        FilterPongOnly;

    }
}

