/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.PingFrameFilter;
import eu.luminis.jmeter.wssampler.WebSocketSamplerGuiPanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PingFrameFilterGuiPanel
extends JPanel {
    private final JRadioButton optionBoth;
    private final JRadioButton onlyPing;
    private final JRadioButton onlyPong;
    JCheckBox replyToPing;

    public PingFrameFilterGuiPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Frame filter behaviour"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        labelPanel.add(new JLabel("Filter (discard):"));
        labelPanel.setMaximumSize(new Dimension(labelPanel.getMaximumSize().width, labelPanel.getMinimumSize().height));
        contentPanel.add(labelPanel);
        labelPanel.setAlignmentX(0.0f);
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new BoxLayout(optionPanel, 1));
        this.optionBoth = new JRadioButton("both ping and pong frames");
        optionPanel.add(this.optionBoth);
        this.optionBoth.setSelected(true);
        this.onlyPing = new JRadioButton("ping frames only");
        optionPanel.add(this.onlyPing);
        this.onlyPong = new JRadioButton("pong frames only");
        optionPanel.add(this.onlyPong);
        ButtonGroup optionGroup = new ButtonGroup();
        optionGroup.add(this.optionBoth);
        optionGroup.add(this.onlyPing);
        optionGroup.add(this.onlyPong);
        contentPanel.add(optionPanel);
        optionPanel.setAlignmentX(0.0f);
        contentPanel.add(Box.createVerticalStrut(20));
        this.replyToPing = new JCheckBox("Automatically respond to ping with a pong");
        contentPanel.add(this.replyToPing);
        this.replyToPing.setAlignmentX(0.0f);
        this.add(contentPanel);
        JPanel aboutPanel = WebSocketSamplerGuiPanel.createAboutPanel(this);
        this.add(aboutPanel);
        aboutPanel.setAlignmentX(0.0f);
    }

    public PingFrameFilter.PingFilterType getFilterType() {
        if (this.onlyPing.isSelected()) {
            return PingFrameFilter.PingFilterType.FilterPingOnly;
        }
        if (this.onlyPong.isSelected()) {
            return PingFrameFilter.PingFilterType.FilterPongOnly;
        }
        if (this.optionBoth.isSelected()) {
            return PingFrameFilter.PingFilterType.FilterAll;
        }
        throw new RuntimeException("Invalid ping filter state");
    }

    public void setFilterType(PingFrameFilter.PingFilterType filterType) {
        if (filterType.equals((Object)PingFrameFilter.PingFilterType.FilterAll)) {
            this.optionBoth.setSelected(true);
        } else if (filterType.equals((Object)PingFrameFilter.PingFilterType.FilterPingOnly)) {
            this.onlyPing.setSelected(true);
        } else if (filterType.equals((Object)PingFrameFilter.PingFilterType.FilterPongOnly)) {
            this.onlyPong.setSelected(true);
        } else {
            throw new RuntimeException("Invalid ping filter state");
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 400);
        frame.getContentPane().add(new PingFrameFilterGuiPanel());
        frame.setVisible(true);
    }
}

