/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.DataPayloadType;
import eu.luminis.jmeter.wssampler.RequestResponseWebSocketSampler;
import eu.luminis.jmeter.wssampler.RequestResponseWebSocketSamplerGuiPanel;
import java.awt.BorderLayout;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;

public class RequestResponseWebSocketSamplerGui
extends AbstractSamplerGui {
    private RequestResponseWebSocketSamplerGuiPanel settingsPanel;

    public RequestResponseWebSocketSamplerGui() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.settingsPanel = new RequestResponseWebSocketSamplerGuiPanel();
        this.add(this.settingsPanel, "Center");
    }

    public void clearGui() {
        super.clearGui();
        this.settingsPanel.clearGui();
    }

    public String getStaticLabel() {
        return "WebSocket request-response Sampler";
    }

    public String getLabelResource() {
        return null;
    }

    public TestElement createTestElement() {
        RequestResponseWebSocketSampler element = new RequestResponseWebSocketSampler();
        this.configureTestElement((TestElement)element);
        return element;
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof RequestResponseWebSocketSampler) {
            RequestResponseWebSocketSampler sampler = (RequestResponseWebSocketSampler)element;
            this.settingsPanel.setCreateNewConnection(sampler.getCreateNewConnection());
            this.settingsPanel.setTLS(sampler.getTLS());
            this.settingsPanel.serverField.setText(sampler.getServer());
            this.settingsPanel.portField.setText(sampler.getPort());
            this.settingsPanel.pathField.setText(sampler.getPath());
            this.settingsPanel.connectionTimeoutField.setText(sampler.getConnectTimeout());
            this.settingsPanel.setType(sampler.getBinary() ? DataPayloadType.Binary : DataPayloadType.Text);
            this.settingsPanel.setRequestData(sampler.getRequestData());
            this.settingsPanel.readTimeoutField.setText(sampler.getReadTimeout());
            this.settingsPanel.setReadDataFromFile(sampler.getLoadDataFromFile());
            this.settingsPanel.setDataFile(sampler.getDataFile());
        }
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        if (element instanceof RequestResponseWebSocketSampler) {
            RequestResponseWebSocketSampler sampler = (RequestResponseWebSocketSampler)element;
            sampler.setTLS(this.settingsPanel.getTLS());
            sampler.setServer(this.settingsPanel.serverField.getText());
            sampler.setPort(this.settingsPanel.portField.getText());
            sampler.setPath(this.settingsPanel.pathField.getText());
            sampler.setConnectTimeout(this.settingsPanel.connectionTimeoutField.getText());
            sampler.setBinary(this.settingsPanel.getType().equals((Object)DataPayloadType.Binary));
            sampler.setRequestData(this.settingsPanel.getRequestData());
            sampler.setCreateNewConnection(this.settingsPanel.newConnection.isSelected());
            sampler.setReadTimeout(this.settingsPanel.readTimeoutField.getText());
            sampler.setLoadDataFromFile(this.settingsPanel.getReadDataFromFile());
            sampler.setDataFile(this.settingsPanel.getDataFile());
        }
    }
}

