/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.ComparisonType;
import eu.luminis.jmeter.wssampler.FrameFilter;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.TextFrame;
import java.util.regex.Pattern;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TextFrameFilter
extends FrameFilter {
    private static Logger log = LoggingManager.getLoggerForClass();
    private Pattern regex = null;

    public TextFrameFilter() {
        this.setComparisonType(ComparisonType.IsPlain);
    }

    @Override
    protected void prepareFilter() {
        if (this.getComparisonType().isRegexComparison()) {
            this.regex = Pattern.compile(this.getMatchValue());
        }
    }

    @Override
    protected boolean matchesFilter(Frame frame) {
        String matchValue = this.getMatchValue();
        if (frame.isText()) {
            TextFrame receivedFrame = (TextFrame)frame;
            String framePayload = receivedFrame.getText();
            switch (this.getComparisonType()) {
                case IsPlain: {
                    return true;
                }
                case Contains: {
                    return matchValue != null && framePayload.contains(matchValue);
                }
                case NotContains: {
                    return matchValue != null && !framePayload.contains(matchValue);
                }
                case Equals: {
                    return matchValue != null && matchValue.equals(framePayload);
                }
                case NotEquals: {
                    return matchValue != null && !matchValue.equals(framePayload);
                }
                case StartsWith: {
                    return matchValue != null && framePayload.startsWith(matchValue);
                }
                case NotStartsWith: {
                    return matchValue != null && !framePayload.startsWith(matchValue);
                }
                case EndsWith: {
                    return matchValue != null && framePayload.endsWith(matchValue);
                }
                case NotEndsWith: {
                    return matchValue != null && !framePayload.endsWith(matchValue);
                }
                case ContainsRegex: {
                    return matchValue != null && this.regex.matcher(framePayload).find();
                }
                case NotContainsRegex: {
                    return matchValue != null && !this.regex.matcher(framePayload).find();
                }
                case EqualsRegex: {
                    return matchValue != null && this.regex.matcher(framePayload).matches();
                }
                case NotEqualsRegex: {
                    return matchValue != null && !this.regex.matcher(framePayload).matches();
                }
            }
            throw new RuntimeException("unknown comparison type");
        }
        return false;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    public ComparisonType getComparisonType() {
        return ComparisonType.valueOf(this.getPropertyAsString("comparisonType", "IsPlain"));
    }

    public void setComparisonType(ComparisonType type) {
        this.setProperty("comparisonType", type.toString());
    }

    public String getMatchValue() {
        return this.getPropertyAsString("matchValue");
    }

    public void setMatchValue(String value) {
        this.setProperty("matchValue", value);
    }
}

