/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.AboutDialog;
import eu.luminis.jmeter.wssampler.GuiUtils;
import eu.luminis.jmeter.wssampler.JErrorMessageLabel;
import eu.luminis.jmeter.wssampler.JMeterUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class WebSocketSamplerGuiPanel
extends JPanel {
    public static final int MIN_CONNECTION_TIMEOUT = 1;
    public static final int MAX_CONNECTION_TIMEOUT = 999999;
    public static final int MIN_READ_TIMEOUT = 0;
    public static final int MAX_READ_TIMEOUT = 999999;
    protected JComboBox<String> protocolSelector;
    protected JTextField serverField;
    protected JTextField portField;
    protected JTextField pathField;
    protected JTextField connectionTimeoutField;
    protected JTextField readTimeoutField;
    protected JLabel portLabel;
    protected JLabel pathLabel;
    protected JLabel serverLabel;
    protected JRadioButton reuseConnection;
    protected JRadioButton newConnection;

    void clearGui() {
        this.protocolSelector.setSelectedItem("ws");
        this.serverField.setText("");
        this.portField.setText("");
        this.pathField.setText("");
    }

    protected JPanel createUrlPanel() {
        JPanel urlPanel = new JPanel(){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component child : this.getComponents()) {
                    child.setEnabled(enabled);
                }
            }
        };
        urlPanel.setLayout(new BoxLayout(urlPanel, 0));
        urlPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Server URL"), BorderFactory.createEmptyBorder(3, 5, 5, 0))));
        this.protocolSelector = new JComboBox<String>(new String[]{"ws", "wss"});
        urlPanel.add(this.protocolSelector);
        urlPanel.add(Box.createHorizontalStrut(10));
        this.serverLabel = new JLabel("Server name or IP:");
        urlPanel.add(this.serverLabel);
        this.serverField = new JTextField();
        this.serverField.setColumns(20);
        this.serverField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.serverField.getMinimumSize().height));
        urlPanel.add(this.serverField);
        this.portLabel = new JLabel("Port:");
        urlPanel.add(this.portLabel);
        this.portField = new JTextField();
        this.addIntegerRangeCheck(this.portField, 1, 65535);
        this.portField.setColumns(5);
        this.portField.setMaximumSize(this.portField.getPreferredSize());
        urlPanel.add(this.portField);
        this.pathLabel = new JLabel("Path:");
        urlPanel.add(this.pathLabel);
        this.pathField = new JTextField();
        this.pathField.setColumns(20);
        this.pathField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.pathField.getMinimumSize().height));
        urlPanel.add(this.pathField);
        return urlPanel;
    }

    protected JPanel createConnectionPanel() {
        final ArrayList<JComponent> connectionRelatedSettings = new ArrayList<JComponent>();
        ActionListener disableConnectionSettingsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = e.getSource() == WebSocketSamplerGuiPanel.this.newConnection;
                for (JComponent c : connectionRelatedSettings) {
                    c.setEnabled(enabled);
                }
            }
        };
        JPanel connectionPanel = new JPanel();
        connectionPanel.setLayout(new BoxLayout(connectionPanel, 1));
        connectionPanel.setBorder(BorderFactory.createTitledBorder("Connection"));
        JPanel outerConnectionButtonPanel = new JPanel(new FlowLayout(0));
        JPanel innerConnectionButtonPanel = new JPanel();
        innerConnectionButtonPanel.setLayout(new BoxLayout(innerConnectionButtonPanel, 1));
        this.reuseConnection = new JRadioButton("use existing connection");
        this.reuseConnection.addActionListener(disableConnectionSettingsAction);
        innerConnectionButtonPanel.add(this.reuseConnection);
        this.newConnection = new JRadioButton("setup new connection");
        this.newConnection.setSelected(true);
        this.newConnection.addActionListener(disableConnectionSettingsAction);
        innerConnectionButtonPanel.add(this.newConnection);
        ButtonGroup connectionButtons = new ButtonGroup();
        connectionButtons.add(this.newConnection);
        connectionButtons.add(this.reuseConnection);
        outerConnectionButtonPanel.add(innerConnectionButtonPanel);
        connectionPanel.add(outerConnectionButtonPanel);
        JPanel urlPanel = this.createUrlPanel();
        connectionRelatedSettings.add(urlPanel);
        connectionPanel.add(urlPanel);
        JPanel connectionTimeoutPanel = new JPanel(new FlowLayout(0));
        connectionTimeoutPanel.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 0));
        JLabel connectionTimeoutLabel = new JLabel("Connection timeout (ms):");
        connectionTimeoutPanel.add(connectionTimeoutLabel);
        this.connectionTimeoutField = new JTextField();
        this.connectionTimeoutField.setColumns(10);
        connectionTimeoutPanel.add(this.connectionTimeoutField);
        JErrorMessageLabel connectionTimeoutErrorLabel = new JErrorMessageLabel();
        connectionTimeoutErrorLabel.setForeground(GuiUtils.getLookAndFeelColor("TextField.errorForeground"));
        this.addIntegerRangeCheck(this.connectionTimeoutField, 1, 999999, connectionTimeoutErrorLabel);
        connectionTimeoutPanel.add(connectionTimeoutErrorLabel);
        connectionRelatedSettings.add(connectionTimeoutLabel);
        connectionRelatedSettings.add(this.connectionTimeoutField);
        connectionRelatedSettings.add(connectionTimeoutErrorLabel);
        connectionPanel.add(connectionTimeoutPanel);
        return connectionPanel;
    }

    protected void setCreateNewConnection(boolean yesOrNo) {
        this.newConnection.setSelected(yesOrNo);
        this.reuseConnection.setSelected(!yesOrNo);
        ActionEvent changedSelectionEvent = new ActionEvent(yesOrNo ? this.newConnection : this.reuseConnection, 0, "dummy");
        Arrays.stream(this.reuseConnection.getActionListeners()).forEach(l -> l.actionPerformed(changedSelectionEvent));
    }

    protected void addIntegerRangeCheck(JTextField input, int min, int max) {
        this.addIntegerRangeCheck(input, min, max, null);
    }

    protected void addIntegerRangeCheck(final JTextField input, final int min, final int max, final JLabel errorMsgField) {
        input.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                WebSocketSamplerGuiPanel.this.checkIntegerInRange(e.getDocument(), min, max, input, errorMsgField);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                WebSocketSamplerGuiPanel.this.checkIntegerInRange(e.getDocument(), min, max, input, errorMsgField);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                WebSocketSamplerGuiPanel.this.checkIntegerInRange(e.getDocument(), min, max, input, errorMsgField);
            }
        });
    }

    private boolean checkIntegerInRange(Document doc, int min, int max, JTextField field, JLabel errorMsgField) {
        boolean ok = false;
        boolean isNumber = false;
        try {
            String literalContent = JMeterUtils.stripJMeterVariables(doc.getText(0, doc.getLength()));
            if (literalContent.trim().length() > 0) {
                int value = Integer.parseInt(literalContent);
                ok = value >= min && value <= max;
                isNumber = true;
            } else {
                ok = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (field != null) {
            if (ok) {
                field.setForeground(GuiUtils.getLookAndFeelColor("TextField.foreground"));
                if (errorMsgField != null) {
                    errorMsgField.setText("");
                }
            } else {
                field.setForeground(GuiUtils.getLookAndFeelColor("TextField.errorForeground"));
                if (isNumber && errorMsgField != null) {
                    errorMsgField.setText("Value must >= " + min + " and <= " + max);
                }
            }
        }
        return ok;
    }

    boolean getTLS() {
        return "wss".equals(this.protocolSelector.getSelectedItem());
    }

    void setTLS(boolean tls) {
        if (tls) {
            this.protocolSelector.setSelectedItem("wss");
        } else {
            this.protocolSelector.setSelectedItem("ws");
        }
    }

    static JPanel createAboutPanel(final JComponent parent) {
        JPanel aboutPanel = new JPanel();
        aboutPanel.setLayout(new FlowLayout(2));
        JLabel aboutLabel = new JLabel("<html>WebSocket Samplers plugin. <a href=\"#\">Check</a> for updates.</html>");
        aboutLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AboutDialog.showDialog(SwingUtilities.getWindowAncestor(parent));
            }
        });
        aboutLabel.setFont(parent.getFont().deriveFont(0, 10.0f));
        aboutLabel.setCursor(new Cursor(12));
        aboutPanel.add(aboutLabel);
        return aboutPanel;
    }
}

