/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.websocket;

import eu.luminis.websocket.DataFrame;
import java.nio.charset.StandardCharsets;

public class TextFrame
extends DataFrame {
    private int payloadSize;
    protected String text;

    public TextFrame(String text) {
        this.text = text;
        this.payloadSize = text.getBytes().length;
    }

    public TextFrame(boolean fin, byte[] payload, int size) {
        super(fin, size);
        this.payloadSize = payload.length;
        this.text = new String(payload, StandardCharsets.UTF_8);
    }

    public String getText() {
        return this.text;
    }

    @Override
    public Object getData() {
        return this.text;
    }

    @Override
    public boolean isText() {
        return true;
    }

    public String toString() {
        return "Text frame with text '" + this.text + "'";
    }

    @Override
    protected byte[] getPayload() {
        return this.text.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    protected byte getOpCode() {
        return 1;
    }

    @Override
    public String getTypeAsString() {
        if (this.isFinalFragment()) {
            return "text";
        }
        return "non-final text";
    }

    @Override
    public int getPayloadSize() {
        return this.payloadSize;
    }
}

