/*
 * Decompiled with CFR 0.152.
 */
package my.jmeter.plugin.control;

import java.io.Serializable;
import java.util.Random;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class PacingController
extends GenericController
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String FIXEDTIME = "PacingController.FixedTime";
    public static final String RANDOMOFFSET = "PacingController.RandomOffset";
    long startTime = 0L;
    long preStartTime = 0L;
    long endTime;
    private transient long fixedTime = 3000L;
    private transient long randomOffset = 100L;
    long rndOffsetValue = 0L;
    protected final Random random = new Random();

    public void setFixedTime(long time) {
        this.setProperty((JMeterProperty)new LongProperty(FIXEDTIME, time));
    }

    public void setFixedTime(String time) {
        this.setProperty((JMeterProperty)new StringProperty(FIXEDTIME, time));
    }

    public long getFixedTime() {
        try {
            return Long.parseLong(this.getPropertyAsString(FIXEDTIME));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String getFixedTimeString() {
        return this.getPropertyAsString(FIXEDTIME);
    }

    public void setRandomOffset(String time) {
        this.setProperty(RANDOMOFFSET, time);
    }

    public long getRandomOffset() {
        return this.getPropertyAsLong(RANDOMOFFSET);
    }

    public String getRandomOffsetString() {
        return this.getPropertyAsString(RANDOMOFFSET);
    }

    public Sampler next() {
        return this.next2();
    }

    private Sampler next1() {
        return null;
    }

    private Sampler next2() {
        if (this.isFirst()) {
            this.startTime = System.currentTimeMillis();
        }
        boolean isLast = this.current == this.subControllersAndSamplers.size();
        Sampler returnValue = super.next();
        if (returnValue == null && isLast) {
            long elapsedTime = 0L;
            long timeBalance = 0L;
            this.rndOffsetValue = this.random.nextInt(100) < 50 ? (long)(this.random.nextDouble() * (double)this.getRandomOffset()) : -((long)(this.random.nextDouble() * (double)this.getRandomOffset()));
            if (this.preStartTime > 0L) {
                timeBalance = this.startTime - this.preStartTime - (this.getFixedTime() + this.rndOffsetValue);
            }
            if (timeBalance <= 0L) {
                timeBalance = 0L;
            }
            this.endTime = System.currentTimeMillis();
            elapsedTime = this.endTime - this.startTime;
            if (this.getFixedTime() + this.rndOffsetValue - elapsedTime - timeBalance >= 0L) {
                this.pause(this.getFixedTime() + this.rndOffsetValue - elapsedTime - timeBalance);
                this.preStartTime = this.startTime;
            } else {
                this.preStartTime = 0L;
            }
        }
        return returnValue;
    }

    public void triggerEndOfLoop() {
    }

    private void pause(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

