/*
 * Decompiled with CFR 0.152.
 */
package my.jmeter.plugin.control;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import my.jmeter.plugin.control.PacingController;
import my.jmeter.plugin.utils.JMeterPluginsUtils;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class PacingControllerGui
extends AbstractControllerGui
implements ActionListener {
    public static final String WIKIPAGE = "club/club_main.php?cmd=board&cb_id=cb_Jmeter&page=1&sfl=&stx=&sop=&sca=&wr_id=461";
    private static final String DELAY_FIELD = "FixedTime Field";
    private static final String RANGE_FIELD = "RandomOffset Field";
    private JTextField FixedTimeField;
    private JTextField RandomOffsetField;

    public PacingControllerGui() {
        this.init();
    }

    public static void error(Exception e, JComponent thrower) {
        JOptionPane.showMessageDialog(thrower, e, "Error", 0);
    }

    public TestElement createTestElement() {
        PacingController pc = new PacingController();
        this.modifyTestElement((TestElement)pc);
        pc.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return pc;
    }

    public void configure(TestElement pc) {
        super.configure(pc);
        if (pc instanceof PacingController) {
            this.setState(((PacingController)pc).getFixedTimeString(), ((PacingController)pc).getRandomOffsetString());
        } else {
            this.setState("1000", "0");
        }
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        if (el instanceof PacingController) {
            ((PacingController)el).setFixedTime(this.FixedTimeField.getText());
            ((PacingController)el).setRandomOffset(this.RandomOffsetField.getText());
        } else {
            this.setState("1000", "0");
        }
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Pacing Controller");
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel threadDelayPropsPanel = new JPanel();
        threadDelayPropsPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        threadDelayPropsPanel.setBorder(BorderFactory.createTitledBorder("[Pacing Time Control    \ub2e8\uc704 : mili-second]"));
        Box avgDelayPanel = Box.createHorizontalBox();
        avgDelayPanel.add(new JLabel("fixed time "));
        avgDelayPanel.add(Box.createHorizontalStrut(5));
        this.FixedTimeField = new JTextField(6);
        this.FixedTimeField.setText("");
        this.FixedTimeField.setName(DELAY_FIELD);
        avgDelayPanel.add(this.FixedTimeField);
        threadDelayPropsPanel.add(avgDelayPanel);
        Box delayDevPanel = Box.createHorizontalBox();
        delayDevPanel.add(new JLabel("(+-)random Offset "));
        delayDevPanel.add(Box.createHorizontalStrut(5));
        this.RandomOffsetField = new JTextField(6);
        this.RandomOffsetField.setText("");
        this.RandomOffsetField.setName(RANGE_FIELD);
        delayDevPanel.add(this.RandomOffsetField);
        threadDelayPropsPanel.add(delayDevPanel);
        threadDelayPropsPanel.setMaximumSize(new Dimension(threadDelayPropsPanel.getMaximumSize().width, threadDelayPropsPanel.getPreferredSize().height));
        this.add(threadDelayPropsPanel);
    }

    private void setState(String fixtime, String rndTime) {
        this.FixedTimeField.setText(fixtime);
        this.FixedTimeField.setEnabled(true);
        this.RandomOffsetField.setText(rndTime);
        this.RandomOffsetField.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.FixedTimeField.setEnabled(true);
        this.RandomOffsetField.setEnabled(true);
    }
}

