/*
 * Decompiled with CFR 0.152.
 */
package my.jmeter.plugin.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;

public abstract class JMeterPluginsUtils {
    private static String PLUGINS_PREFIX = "[STEN] - ";
    private static boolean prefixPlugins = true;
    public static final String WIKI_BASE = "http://www.sten.or.kr/";

    static {
        String prefixPluginsCfg = JMeterUtils.getProperty((String)"jmeterPlugin.prefixPlugins");
        if (prefixPluginsCfg != null) {
            prefixPlugins = "true".equalsIgnoreCase(prefixPluginsCfg.trim());
        }
    }

    public static String prefixLabel(String label) {
        return prefixPlugins ? String.valueOf(PLUGINS_PREFIX) + label : label;
    }

    public static String getStackTrace(Exception ex) {
        StackTraceElement[] stack = ex.getStackTrace();
        StringBuilder res = new StringBuilder();
        int n = 0;
        while (n < stack.length) {
            res.append("at ");
            res.append(stack[n].toString());
            res.append("\n");
            ++n;
        }
        return res.toString();
    }

    public static CollectionProperty tableModelRowsToCollectionProperty(PowerTableModel model, String propname) {
        CollectionProperty rows = new CollectionProperty(propname, new ArrayList());
        int row = 0;
        while (row < model.getRowCount()) {
            List<Object> item = JMeterPluginsUtils.getArrayListForArray(model.getRowData(row));
            rows.addItem(item);
            ++row;
        }
        return rows;
    }

    public static CollectionProperty tableModelRowsToCollectionPropertyEval(PowerTableModel model, String propname) {
        CollectionProperty rows = new CollectionProperty(propname, new ArrayList());
        int row = 0;
        while (row < model.getRowCount()) {
            List<Object> item = JMeterPluginsUtils.getArrayListForArrayEval(model.getRowData(row));
            rows.addItem(item);
            ++row;
        }
        return rows;
    }

    public static void collectionPropertyToTableModelRows(CollectionProperty prop, PowerTableModel model) {
        model.clearData();
        int rowN = 0;
        while (rowN < prop.size()) {
            ArrayList rowObject = (ArrayList)prop.get(rowN).getObjectValue();
            model.addRow(rowObject.toArray());
            ++rowN;
        }
        model.fireTableDataChanged();
    }

    public static void collectionPropertyToTableModelRows(CollectionProperty prop, PowerTableModel model, Class[] columnClasses) {
        model.clearData();
        int rowN = 0;
        while (rowN < prop.size()) {
            ArrayList rowStrings = (ArrayList)prop.get(rowN).getObjectValue();
            ArrayList<Object> rowObject = new ArrayList<Object>(rowStrings.size());
            int i = 0;
            while (i < columnClasses.length && i < rowStrings.size()) {
                rowObject.add(JMeterPluginsUtils.convertToClass((StringProperty)rowStrings.get(i), columnClasses[i]));
                ++i;
            }
            if (rowObject.size() < columnClasses.length) {
                i = rowObject.size();
                while (i < columnClasses.length) {
                    rowObject.add(new Object());
                    ++i;
                }
            }
            model.addRow(rowObject.toArray());
            ++rowN;
        }
        model.fireTableDataChanged();
    }

    private static List<Object> getArrayListForArray(Object[] rowData) {
        ArrayList<Object> res = new ArrayList<Object>();
        int n = 0;
        while (n < rowData.length) {
            res.add(rowData[n]);
            ++n;
        }
        return res;
    }

    private static List<Object> getArrayListForArrayEval(Object[] rowData) {
        ArrayList<Object> res = new ArrayList<Object>();
        int n = 0;
        while (n < rowData.length) {
            res.add(new CompoundVariable(rowData[n].toString()).execute());
            ++n;
        }
        return res;
    }

    public static String byteBufferToString(ByteBuffer buf) {
        byte[] dst = JMeterPluginsUtils.byteBufferToByteArray(buf);
        return new String(dst);
    }

    public static byte[] byteBufferToByteArray(ByteBuffer buf) {
        ByteBuffer str = buf.duplicate();
        str.rewind();
        byte[] dst = new byte[str.limit()];
        str.get(dst);
        return dst;
    }

    public static String replaceRNT(String str) {
        str = str.replaceAll("\\\\\\\\", "VERY BAD WAY");
        str = str.replaceAll("\\\\t", "\t");
        str = str.replaceAll("\\\\n", "\n");
        str = str.replaceAll("\\\\r", "\r");
        str = str.replaceAll("VERY BAD WAY", "\\\\");
        return str;
    }

    public static String getWikiLinkText(String wikiPage) {
        if (!Desktop.isDesktopSupported()) {
            return "Plugin help available here: http://www.sten.or.kr/" + wikiPage;
        }
        return "";
    }

    private static Object convertToClass(StringProperty value, Class aClass) {
        if (Boolean.class.equals((Object)aClass)) {
            return Boolean.valueOf(value.getStringValue());
        }
        return value;
    }

    public static Component addHelpLinkToPanel(Container panel, String helpPage) {
        if (!Desktop.isDesktopSupported()) {
            return panel;
        }
        JLabel icon = new JLabel();
        icon.setIcon(new ImageIcon(JMeterPluginsUtils.class.getResource("/my/jmeter/plugin/resources/information.png")));
        JLabel link = new JLabel("Plugin \uc124\uba85");
        link.setForeground(Color.BLUE);
        link.setFont(link.getFont().deriveFont(0));
        link.setCursor(new Cursor(12));
        link.addMouseListener(new URIOpener(WIKI_BASE + helpPage));
        MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.blue);
        link.setBorder(border);
        JLabel version = new JLabel("v" + JMeterPluginsUtils.getVersion());
        version.setFont(version.getFont().deriveFont(0).deriveFont(11.0f));
        version.setForeground(Color.GRAY);
        Container innerPanel = JMeterPluginsUtils.findComponentWithBorder((JComponent)panel, EtchedBorder.class);
        JPanel panelLink = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        panelLink.add((Component)icon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 3, 0);
        panelLink.add((Component)link, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        panelLink.add((Component)version, gridBagConstraints);
        if (innerPanel != null) {
            innerPanel.add(panelLink);
        } else {
            panel.add(panelLink);
        }
        return panel;
    }

    private static Container findComponentWithBorder(JComponent panel, Class<?> aClass) {
        int n = 0;
        while (n < panel.getComponentCount()) {
            if (panel.getComponent(n) instanceof JComponent) {
                JComponent comp = (JComponent)panel.getComponent(n);
                if (comp.getBorder() != null && aClass.isAssignableFrom(comp.getBorder().getClass())) {
                    return comp;
                }
                Container con = JMeterPluginsUtils.findComponentWithBorder(comp, aClass);
                if (con != null) {
                    return con;
                }
            }
            ++n;
        }
        return null;
    }

    public static void doBestCSVSetup(SampleSaveConfiguration conf) {
        conf.setAsXml(false);
        conf.setFieldNames(true);
        conf.setFormatter(null);
        conf.setSamplerData(false);
        conf.setRequestHeaders(false);
        conf.setFileName(false);
        conf.setIdleTime(false);
        conf.setSuccess(true);
        conf.setMessage(true);
        conf.setEncoding(false);
        conf.setThreadCounts(true);
        conf.setFieldNames(true);
        conf.setAssertions(false);
        conf.setResponseData(false);
        conf.setSubresults(false);
        conf.setLatency(true);
        conf.setLabel(true);
        conf.setThreadName(false);
        conf.setBytes(true);
        conf.setHostname(false);
        conf.setAssertionResultsFailureMessage(false);
        conf.setResponseHeaders(false);
        conf.setUrl(false);
        conf.setTime(true);
        conf.setTimestamp(true);
        conf.setCode(true);
        conf.setDataType(false);
        conf.setSampleCount(false);
    }

    public static void openInBrowser(String string) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public static float getFloatFromString(String stringValue, float defaultValue) {
        float ret;
        if (stringValue != null) {
            try {
                ret = Float.valueOf(stringValue).floatValue();
            }
            catch (NumberFormatException ex) {
                ret = defaultValue;
            }
        } else {
            ret = defaultValue;
        }
        return ret;
    }

    public static int getSecondsForShortString(String string) {
        int res = 0;
        string = string.trim();
        String curNum = "";
        int n = 0;
        while (n < string.length()) {
            String c = String.valueOf(string.charAt(n));
            if (c.matches("\\d")) {
                curNum = String.valueOf(curNum) + c;
            } else {
                int mul;
                switch (c.charAt(0)) {
                    case 'S': 
                    case 's': {
                        mul = 1;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        mul = 60;
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        mul = 3600;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        mul = 86400;
                        break;
                    }
                    default: {
                        throw new NumberFormatException("Shorthand string does not allow using '" + c + "'");
                    }
                }
                res += Integer.parseInt(curNum) * mul;
                curNum = "";
            }
            ++n;
        }
        if (!curNum.isEmpty()) {
            res += Integer.parseInt(curNum);
        }
        return res;
    }

    public static String getVersion() {
        String version = "2.0";
        return version;
    }

    private static class URIOpener
    extends MouseAdapter {
        private final String uri;

        public URIOpener(String aURI) {
            this.uri = aURI;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 0x10) == 16) {
                JMeterPluginsUtils.openInBrowser(this.uri);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

