/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.controller;

import com.blazemeter.jmeter.controller.DummyThreadGroup;
import com.blazemeter.jmeter.controller.JMeterThreadParallel;
import com.blazemeter.jmeter.controller.ParallelListenerNotifier;
import com.blazemeter.jmeter.controller.traverse.CustomTreeCloner;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterContextServiceAccessorParallel;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.SearchByClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSampler
extends AbstractSampler
implements Controller,
ThreadListener,
Interruptible,
JMeterThreadMonitor,
TestStateListener,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ParallelSampler.class);
    private static final String GENERATE_PARENT = "PARENT_SAMPLE";
    private static final String MAX_THREAD_NUMBER = "MAX_THREAD_NUMBER";
    private static final String LIMIT_MAX_THREAD_NUMBER = "LIMIT_MAX_THREAD_NUMBER";
    protected List<TestElement> controllers = new ArrayList<TestElement>();
    protected final ParallelListenerNotifier notifier = new ParallelListenerNotifier();
    private ExecutorService executorService;
    private DummyThreadGroup threadGroup;

    public void addTestElement(TestElement te) {
        if (te instanceof Controller || te instanceof Sampler) {
            this.controllers.add(te);
        }
        log.debug("Added {}, list size: {}", (Object)te, (Object)this.controllers.size());
    }

    public void setRunningVersion(boolean runningVersion) {
        super.setRunningVersion(runningVersion);
        for (TestElement ctl : this.controllers) {
            ctl.setRunningVersion(runningVersion);
        }
    }

    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        res.setResponseCode("200");
        res.setResponseMessage("OK");
        res.setSuccessful(true);
        res.setSampleLabel(this.getName());
        res.setResponseData("".getBytes());
        this.notifier.setContainer(res);
        LinkedList<JMeterThreadParallel> jMeterThreads = new LinkedList<JMeterThreadParallel>();
        this.threadGroup.reset();
        StringBuilder reqText = new StringBuilder("Parallel items:\n");
        for (TestElement ctl : this.controllers) {
            reqText.append(ctl.getName()).append("\n");
            JMeterThreadParallel jMeterThreadParallel = new JMeterThreadParallel(this.getTestTree(ctl), this, this.notifier, this.getGenerateParent());
            String name = JMeterContextService.getContext().getThread() + " - " + this.getName() + " - " + ctl.getName();
            jMeterThreadParallel.setThreadName(name);
            jMeterThreadParallel.setThreadGroup(this.threadGroup);
            jMeterThreadParallel.setEngine(JMeterContextService.getContext().getEngine());
            this.injectVariables(jMeterThreadParallel, this.getThreadContext());
            jMeterThreads.add(jMeterThreadParallel);
            this.threadGroup.addThread(jMeterThreadParallel);
        }
        res.setSamplerData(reqText.toString());
        res.sampleStart();
        LinkedList futures = new LinkedList();
        for (JMeterThread jMeterThread : jMeterThreads) {
            futures.add(this.executorService.submit((Runnable)jMeterThread));
        }
        for (Future future : futures) {
            try {
                future.get();
                log.debug("Thread is done {}", (Object)future.isDone());
            }
            catch (InterruptedException | ExecutionException e1) {
                log.debug("Interrupted {}", (Object)future.isCancelled());
            }
        }
        if (res.getEndTime() == 0L) {
            res.sampleEnd();
        }
        return this.getGenerateParent() ? res : null;
    }

    private HashTree getTestTree(TestElement te) {
        CustomLoopController wrapper = new CustomLoopController(JMeterContextService.getContext());
        wrapper.setLoops(1);
        wrapper.setContinueForever(false);
        wrapper.addTestElement(te);
        wrapper.setName("wrapped " + te.getName());
        wrapper.setRunningVersion(this.isRunningVersion());
        HashTree tree = new HashTree();
        HashTree subTree = this.getSubTree(te);
        if (subTree != null) {
            tree.add((Object)wrapper, subTree);
        } else {
            tree.add((Object)wrapper);
        }
        return tree;
    }

    private HashTree getSubTree(TestElement te) {
        try {
            Field field = JMeterThread.class.getDeclaredField("testTree");
            field.setAccessible(true);
            JMeterThread parentThread = JMeterContextService.getContext().getThread();
            if (parentThread == null) {
                log.error("Current thread is null.");
                throw new NullPointerException();
            }
            HashTree testTree = (HashTree)field.get(parentThread);
            SearchByClass searcher = new SearchByClass(te.getClass());
            testTree.traverse((HashTreeTraverser)searcher);
            return searcher.getSubTree((Object)te);
        }
        catch (ReflectiveOperationException ex) {
            log.warn("Can not get sub tree for Test element " + te.getName(), (Throwable)ex);
            return null;
        }
    }

    public boolean interrupt() {
        this.executorService.shutdown();
        return true;
    }

    public Sampler next() {
        return null;
    }

    public boolean isDone() {
        return true;
    }

    public void initialize() {
        log.debug("Initialize");
    }

    public void triggerEndOfLoop() {
        log.debug("Trigger End of loop");
    }

    public void threadFinished(JMeterThread thread) {
        JMeterContextServiceAccessorParallel.incrNumberOfThreads();
        try {
            Field field = AbstractTestElement.class.getDeclaredField("threadContext");
            field.setAccessible(true);
            if (thread instanceof JMeterThreadParallel) {
                JMeterThreadParallel pthr = (JMeterThreadParallel)thread;
                for (TestElement testElement : pthr.getParallelCompiler().getKnownElements()) {
                    field.set(testElement, null);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.warn("Failed to reset context", (Throwable)e);
        }
    }

    public void addIterationListener(LoopIterationListener listener) {
    }

    public void removeIterationListener(LoopIterationListener iterationListener) {
    }

    public int getMaxThreadNumber() {
        return this.getPropertyAsInt(MAX_THREAD_NUMBER, 6);
    }

    public void setMaxThreadNumber(int value) {
        this.setProperty(MAX_THREAD_NUMBER, value);
    }

    public boolean getLimitMaxThreadNumber() {
        return this.getPropertyAsBoolean(LIMIT_MAX_THREAD_NUMBER);
    }

    public void setLimitMaxThreadNumber(boolean value) {
        this.setProperty(LIMIT_MAX_THREAD_NUMBER, value);
    }

    public boolean getGenerateParent() {
        return this.getPropertyAsBoolean(GENERATE_PARENT);
    }

    public void setGenerateParent(boolean value) {
        this.setProperty(GENERATE_PARENT, value);
    }

    private void injectVariables(JMeterThread jmThread, JMeterContext threadContext) {
        if (threadContext != null && threadContext.getVariables() != null) {
            try {
                Class<JMeterThread> cls = JMeterThread.class;
                Field vars = cls.getDeclaredField("threadVars");
                vars.setAccessible(true);
                vars.set(jmThread, threadContext.getVariables());
            }
            catch (Throwable ex) {
                log.warn("Cannot inject variables into parallel thread ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeVariablesMap() {
        block8: {
            try {
                Object obj;
                JMeterContext context = this.getThreadContext();
                if (context == null || context.getVariables() == null) break block8;
                JMeterVariables jMeterVariables = context.getVariables();
                Class<JMeterVariables> cls = JMeterVariables.class;
                Field variablesField = cls.getDeclaredField("variables");
                variablesField.setAccessible(true);
                Object object = obj = variablesField.get(jMeterVariables);
                synchronized (object) {
                    if (obj instanceof Map) {
                        Map variables = (Map)obj;
                        if (!(variables instanceof ConcurrentHashMap)) {
                            variablesField.set(jMeterVariables, new ConcurrentHashMap(variables));
                        }
                    } else {
                        log.warn("Unexpected variables map type " + obj.getClass().getName());
                    }
                }
            }
            catch (Throwable ex) {
                log.warn("Cannot change variables map ", ex);
            }
        }
    }

    public void threadStarted() {
        this.changeVariablesMap();
        if (this.getLimitMaxThreadNumber()) {
            log.info("Starting up to {} threads", (Object)this.getMaxThreadNumber());
            this.executorService = Executors.newFixedThreadPool(this.getMaxThreadNumber(), new ParallelThreadFactory(this.getName()));
        } else {
            this.executorService = Executors.newCachedThreadPool(new ParallelThreadFactory(this.getName()));
        }
        this.threadGroup = new DummyThreadGroup();
        this.addThreadGroupToEngine(this.threadGroup);
    }

    public void threadFinished() {
        this.executorService.shutdown();
        this.removeThreadGroupFromEngine(this.threadGroup);
    }

    private void addThreadGroupToEngine(AbstractThreadGroup group) {
        try {
            StandardJMeterEngine engine = JMeterContextService.getContext().getEngine();
            Field groupsField = StandardJMeterEngine.class.getDeclaredField("groups");
            groupsField.setAccessible(true);
            List groups = (List)groupsField.get(engine);
            groups.add(group);
        }
        catch (ReflectiveOperationException ex) {
            log.warn("Can not add DummyThreadGroup to engine", (Throwable)ex);
        }
    }

    private void removeThreadGroupFromEngine(AbstractThreadGroup group) {
        try {
            StandardJMeterEngine engine = JMeterContextService.getContext().getEngine();
            Field groupsField = StandardJMeterEngine.class.getDeclaredField("groups");
            groupsField.setAccessible(true);
            List groups = (List)groupsField.get(engine);
            groups.remove(group);
        }
        catch (ReflectiveOperationException ex) {
            log.warn("Can not remove DummyThreadGroup from engine", (Throwable)ex);
        }
    }

    public void testStarted() {
        this.testStarted("*local*");
    }

    public void testStarted(String s) {
        this.changeCookieManager();
    }

    private void changeCookieManager() {
        try {
            StandardJMeterEngine engine = this.getStandardJMeterEngine();
            Field field = StandardJMeterEngine.class.getDeclaredField("test");
            field.setAccessible(true);
            HashTree testTree = (HashTree)field.get(engine);
            HashTree newHashTree = this.makeCookieManagerThreadSafe(testTree);
            field.set(engine, newHashTree);
        }
        catch (Throwable ex) {
            log.warn("Cannot change cookie manager", ex);
        }
    }

    private HashTree makeCookieManagerThreadSafe(HashTree testTree) {
        CustomTreeCloner cloner = new CustomTreeCloner();
        testTree.traverse((HashTreeTraverser)cloner);
        return cloner.getClonedTree();
    }

    public StandardJMeterEngine getStandardJMeterEngine() throws IllegalAccessException, NoSuchFieldException {
        Field engine = StandardJMeterEngine.class.getDeclaredField("engine");
        engine.setAccessible(true);
        return (StandardJMeterEngine)engine.get(null);
    }

    public void testEnded() {
    }

    public void testEnded(String s) {
    }

    public static class ParallelThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final String namePrefix;

        public ParallelThreadFactory(String controllerName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "parallel " + controllerName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix, 0L);
            this.cleanThreadContext(t);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }

        private void cleanThreadContext(Thread thread) {
            try {
                Field field2 = Thread.class.getDeclaredField("inheritableThreadLocals");
                field2.setAccessible(true);
                field2.set(thread, null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private static class CustomLoopController
    extends LoopController {
        private final JMeterContext context;
        private boolean isFinished = false;

        public CustomLoopController(JMeterContext context) {
            this.context = context;
        }

        public boolean isDone() {
            return this.isFinished || super.isDone();
        }

        public void triggerEndOfLoop() {
            this.isFinished = true;
            this.context.setRestartNextLoop(true);
            super.triggerEndOfLoop();
        }
    }
}

