/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.color;

import com.github.weisj.darklaf.color.ColorUtil;
import com.github.weisj.darklaf.color.DarkColorModel;
import com.github.weisj.darklaf.color.DarkColorModelHSB;
import com.github.weisj.darklaf.color.DarkColorModelHSL;
import com.github.weisj.darklaf.color.DarkColorModelRGB;
import com.github.weisj.darklaf.components.DefaultColorPipette;
import com.github.weisj.darklaf.components.border.DarkBorders;
import com.github.weisj.darklaf.components.border.MarginBorderWrapper;
import com.github.weisj.darklaf.components.chooser.ChooserComponent;
import com.github.weisj.darklaf.layout.LayoutHelper;
import com.github.weisj.darklaf.ui.colorchooser.ColorPipette;
import com.github.weisj.darklaf.ui.colorchooser.ColorPreviewComponent;
import com.github.weisj.darklaf.ui.colorchooser.ColorTriangle;
import com.github.weisj.darklaf.ui.colorchooser.ColorValueFormatter;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;

public class SmallColorChooser
extends JPanel
implements ChooserComponent<Color> {
    private static final DarkColorModel[] COLOR_MODELS = new DarkColorModel[]{DarkColorModelRGB.getInstance(), DarkColorModelHSB.getInstance(), DarkColorModelHSL.getInstance()};
    protected ColorTriangle colorTriangle;
    protected ColorPreviewComponent previewComponent;
    private Consumer<Color> callback;
    private Color initial;
    protected boolean valueChanging;
    protected JTabbedPane colorModelTabbedPane;
    protected JFormattedTextField hexField;
    protected Map<DarkColorModel, Runnable> updateMap = new HashMap<DarkColorModel, Runnable>();
    protected ColorValueFormatter hexFormatter;
    protected ColorPipette pipette;

    public SmallColorChooser() {
        this(Color.BLACK, c -> {});
    }

    public SmallColorChooser(Color initial, Consumer<Color> callback) {
        this.setValueChanging(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.createTopComponent(), constraints);
        constraints.gridy = 1;
        this.add((Component)this.createCenterComponent(), constraints);
        constraints.gridy = 2;
        this.add((Component)this.createBottomComponent(), constraints);
        this.setOpaque(false);
        this.setValueChanging(false);
        this.initListeners();
        this.reset(initial, callback);
    }

    @Override
    public void reset(Color initial, Consumer<Color> callback) {
        this.callback = callback;
        this.initial = initial;
        this.colorTriangle.setColor(this, initial);
    }

    @Override
    public Color getInitial() {
        return this.initial;
    }

    @Override
    public Color getSelected() {
        return this.getColor();
    }

    protected void initListeners() {
        this.colorModelTabbedPane.addChangeListener(e -> {
            this.hexFormatter.setModel(this.getDarkColorModel());
            this.colorTriangle.setColorModel(this.getDarkColorModel());
        });
        this.colorTriangle.addListener((c, o) -> {
            this.previewComponent.setColor(c);
            for (DarkColorModel model : COLOR_MODELS) {
                if (o == model) continue;
                this.updateMap.get(model).run();
            }
            if (o != this.hexField) {
                this.hexField.setText(ColorUtil.toHex(c));
            }
        });
        this.hexField.getDocument().addDocumentListener(() -> {
            try {
                String hexStr = String.format("%1$-8s", this.hexField.getText()).replaceAll(" ", "F");
                int[] rgb = new int[]{Integer.valueOf(hexStr.substring(0, 2), 16), Integer.valueOf(hexStr.substring(2, 4), 16), Integer.valueOf(hexStr.substring(4, 6), 16)};
                this.setColor(this.hexField, DarkColorModelRGB.getInstance(), rgb);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        });
    }

    protected void setColor(DarkColorModel source2, int ... values) {
        this.setColor((Object)source2, source2, values);
    }

    protected void setColor(Object source2, DarkColorModel model, int ... values) {
        if (this.isValueChanging()) {
            return;
        }
        this.setValueChanging(true);
        if (model != null) {
            this.colorTriangle.setColorFromModel(source2, model, values);
        }
        if (this.callback != null && this.isShowing()) {
            this.callback.accept(this.colorTriangle.getColor());
        }
        this.setValueChanging(false);
    }

    public boolean isValueChanging() {
        return this.valueChanging;
    }

    public void setValueChanging(boolean valueChanging) {
        this.valueChanging = valueChanging;
    }

    protected JComponent createTopComponent() {
        this.colorTriangle = this.createColorWheel();
        JPanel holder = new JPanel(new BorderLayout());
        holder.setOpaque(false);
        holder.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        holder.add((Component)this.colorTriangle, "Center");
        return holder;
    }

    protected JComponent createCenterComponent() {
        this.colorModelTabbedPane = new JTabbedPane(){

            @Override
            public Color getBackground() {
                Container parent = this.getParent();
                return parent != null ? parent.getBackground() : super.getBackground();
            }
        };
        this.colorModelTabbedPane.putClientProperty("JTabbedPane.centerTabs", true);
        this.colorModelTabbedPane.setOpaque(false);
        this.addColorModels(this.colorModelTabbedPane, COLOR_MODELS);
        this.colorModelTabbedPane.setBorder(DarkBorders.createLineBorder(1, 0, 1, 0));
        return this.colorModelTabbedPane;
    }

    protected JComponent createBottomComponent() {
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.previewComponent = this.createPreviewComponent();
        JPanel hexFieldHolder = new JPanel(new GridBagLayout());
        hexFieldHolder.setOpaque(false);
        Box hexBox = Box.createHorizontalBox();
        JLabel label = new JLabel("#");
        hexBox.add(label);
        hexBox.add(this.createHexField());
        hexFieldHolder.add(hexBox);
        box.add(this.previewComponent);
        box.add(Box.createGlue());
        box.add(hexFieldHolder);
        box.add(Box.createGlue());
        box.add(this.createPipetteButton());
        return box;
    }

    private JButton createPipetteButton() {
        Icon pipetteIcon = UIManager.getIcon("ColorChooser.pipette.icon");
        if (pipetteIcon == null) {
            pipetteIcon = DarkUIUtil.ICON_LOADER.getIcon("misc/pipette.svg", true);
        }
        Icon pipetteHoverIcon = UIManager.getIcon("ColorChooser.pipetteRollover.icon");
        JButton pipetteButton = new JButton();
        DefaultColorPipette defaultPipette = new DefaultColorPipette(this, (c, o) -> this.setColor(pipetteButton, DarkColorModelRGB.getInstance(), c.getRed(), c.getGreen(), c.getBlue()));
        pipetteButton.putClientProperty("JButton.thin", Boolean.TRUE);
        pipetteButton.putClientProperty("JButton.square", Boolean.TRUE);
        pipetteButton.setRolloverEnabled(true);
        pipetteButton.setFocusable(false);
        pipetteButton.setIcon(pipetteIcon);
        pipetteButton.setRolloverIcon(pipetteHoverIcon);
        pipetteButton.setDisabledIcon(pipetteHoverIcon);
        pipetteButton.setPressedIcon(pipetteHoverIcon);
        pipetteButton.addActionListener(e -> {
            pipetteButton.setEnabled(false);
            this.pipette.setInitialColor(this.getColor());
            this.pipette.show();
        });
        defaultPipette.setCloseAction(() -> pipetteButton.setEnabled(true));
        this.pipette = defaultPipette;
        return pipetteButton;
    }

    protected JComponent createHexField() {
        this.hexField = new JFormattedTextField();
        this.hexField.setColumns(6);
        this.hexField.setMargin(new Insets(2, 2, 2, 2));
        this.hexField.setFocusLostBehavior(1);
        this.hexFormatter = ColorValueFormatter.init(null, 0, true, this.hexField);
        this.hexFormatter.setModel(this.getDarkColorModel());
        GraphicsUtil.setOpaqueBuffered(this.hexField, true);
        return this.hexField;
    }

    public Color getColor() {
        return this.colorTriangle.getColor();
    }

    public DarkColorModel getDarkColorModel() {
        return COLOR_MODELS[this.colorModelTabbedPane.getSelectedIndex()];
    }

    public boolean isPipetteShowing() {
        return this.pipette != null && this.pipette.isShowing();
    }

    protected void addColorModels(JTabbedPane tabbedPane, DarkColorModel ... colorModels) {
        if (colorModels == null || colorModels.length == 0) {
            throw new IllegalArgumentException("Must pass at least one valid colorModel");
        }
        for (DarkColorModel model : colorModels) {
            tabbedPane.addTab(model.toString(), this.createColorModelComponent(model));
        }
    }

    protected JComponent createColorModelComponent(DarkColorModel model) {
        Box box = Box.createVerticalBox();
        box.setBorder(LayoutHelper.createEmptyContainerBorder());
        String[] descriptors = model.getFullLabelDescriptorsBefore();
        String[] descriptorsAfter = model.getFullLabelDescriptorsAfter();
        int count = model.getCount();
        JSlider[] sliders = new JSlider[count];
        Descriptor[] labels = new Descriptor[count];
        for (int i = 0; i < count; ++i) {
            JSlider slider = new JSlider(model.getMinimum(i), model.getMaximum(i));
            slider.putClientProperty("JSlider.instantScrollEnabled", true);
            slider.setValue(model.getDefault(i));
            slider.setSnapToTicks(false);
            slider.setPaintLabels(false);
            slider.setOpaque(false);
            Descriptor label = new Descriptor(descriptors[i], descriptorsAfter[i], model.getMinimum(i), model.getMaximum(i), slider::setValue);
            label.setLabelFor(slider);
            label.setBorder(BorderFactory.createEmptyBorder(0, LayoutHelper.getDefaultSpacing(), 0, 0));
            JPanel holder = new JPanel(new BorderLayout());
            holder.setOpaque(false);
            holder.add((Component)label, "First");
            holder.add((Component)slider, "Center");
            box.add(holder);
            sliders[i] = slider;
            labels[i] = label;
            label.setValue(String.valueOf(slider.getValue()));
            slider.addChangeListener(e -> {
                if (this.isValueChanging()) {
                    return;
                }
                int[] values = new int[count];
                for (int j = 0; j < count; ++j) {
                    values[j] = sliders[j].getValue();
                }
                label.setValue(String.valueOf(slider.getValue()));
                this.setColor(model, values);
            });
        }
        this.updateMap.put(model, () -> {
            int[] values = this.colorTriangle.getValuesForModel(model);
            for (int i = 0; i < count; ++i) {
                sliders[i].setValue(values[i]);
                labels[i].setValue(String.valueOf(values[i]));
            }
        });
        return box;
    }

    protected ColorTriangle createColorWheel() {
        ColorTriangle wheel = new ColorTriangle();
        wheel.setMinimumSize(150);
        wheel.setOpaque(false);
        return wheel;
    }

    protected ColorPreviewComponent createPreviewComponent() {
        return new ColorPreviewComponent(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = SmallColorChooser.this.hexField.getPreferredSize();
                Border border = MarginBorderWrapper.getBorder(SmallColorChooser.this.hexField);
                Insets ins = border != null ? border.getBorderInsets(SmallColorChooser.this.hexField) : null;
                int size = dim.height;
                if (ins != null) {
                    size -= ins.top + ins.bottom;
                }
                dim.width = size;
                dim.height = size;
                return dim;
            }
        };
    }

    protected static class Descriptor
    extends JPanel {
        private final JFormattedTextField textField;
        private final JLabel label;

        public Descriptor(String before, final String after, final int min, final int max, Consumer<Integer> callback) {
            this.setLayout(new BoxLayout(this, 2));
            this.setAlignmentX(0.0f);
            this.label = new JLabel(before + ":");
            this.add(this.label);
            this.textField = new JFormattedTextField(new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(final JFormattedTextField tf) {
                    return new JFormattedTextField.AbstractFormatter(){
                        private final DocumentFilter documentFilter = new DocumentFilter(){

                            @Override
                            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                                if (!this.isValidString(string)) {
                                    return;
                                }
                                super.insertString(fb, offset, string, attr);
                            }

                            @Override
                            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                                if (!this.isValidString(text)) {
                                    return;
                                }
                                super.replace(fb, offset, length, text, attrs);
                            }

                            private boolean isValidString(String text) {
                                for (int i = 0; i < text.length(); ++i) {
                                    char c = text.charAt(i);
                                    if (c >= '0' && c <= '9') continue;
                                    return false;
                                }
                                return true;
                            }
                        };
                        private final NavigationFilter navigationFilter = new NavigationFilter(){

                            @Override
                            public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                                super.setDot(fb, this.clampDot(dot, tf), bias);
                            }

                            @Override
                            public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                                super.moveDot(fb, this.clampDot(dot, tf), bias);
                            }

                            @Override
                            public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
                                return this.clampDot(super.getNextVisualPositionFrom(text, pos, bias, direction, biasRet), text);
                            }

                            private int clampDot(int dot, JTextComponent c) {
                                return Math.max(0, Math.min(dot, c.getDocument().getLength() - after.length()));
                            }
                        };

                        @Override
                        public void install(JFormattedTextField ftf) {
                            super.install(ftf);
                            ftf.setCaretPosition(ftf.getCaretPosition());
                        }

                        @Override
                        public Object stringToValue(String text) throws ParseException {
                            int value = Integer.parseInt(text.substring(0, text.length() - after.length()));
                            if (value < min || value > max) {
                                throw new ParseException(text, 0);
                            }
                            return value;
                        }

                        @Override
                        public String valueToString(Object value) {
                            return value + after;
                        }

                        @Override
                        protected DocumentFilter getDocumentFilter() {
                            return this.documentFilter;
                        }

                        @Override
                        protected NavigationFilter getNavigationFilter() {
                            return this.navigationFilter;
                        }
                    };
                }
            });
            AtomicBoolean adjusting = new AtomicBoolean();
            this.textField.addPropertyChangeListener("value", e -> {
                if (adjusting.get()) {
                    return;
                }
                adjusting.set(true);
                if (this.textField.getValue() instanceof Integer) {
                    callback.accept((Integer)this.textField.getValue());
                }
                adjusting.set(false);
            });
            this.textField.setBorder(BorderFactory.createEmptyBorder());
            this.textField.setOpaque(false);
            this.setOpaque(false);
            this.add(this.textField);
            this.setValue(min);
        }

        public void setValue(Object value) {
            this.textField.setValue(value);
        }

        public void setLabelFor(JComponent c) {
            this.label.setLabelFor(c);
        }
    }
}

