/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.extensions.rsyntaxarea;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.extensions.rsyntaxarea.DarklafIconGroup;
import com.github.weisj.darklaf.extensions.rsyntaxarea.IconGroupDelegate;
import com.github.weisj.darklaf.extensions.rsyntaxarea.RSyntaxTheme;
import com.github.weisj.darklaf.extensions.rsyntaxarea.scheme.DarklafSyntaxScheme;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;

public class DarklafRSyntaxTheme
extends RSyntaxTheme {
    public DarklafRSyntaxTheme() {
        this(new RSyntaxTextArea());
    }

    public DarklafRSyntaxTheme(RSyntaxTextArea textArea) {
        super(textArea);
    }

    protected void updateTheme(RSyntaxTextArea textArea) {
        this.bgColor = UIManager.getColor("textBackgroundSecondary");
        this.caretColor = UIManager.getColor("caret");
        this.useSelectionFG = false;
        this.selectionBG = UIManager.getColor("textSelectionBackground");
        this.selectionRoundedEdges = false;
        this.currentLineHighlight = UIManager.getColor("textSelectionBackgroundSecondary");
        this.fadeCurrentLineHighlight = false;
        this.tabLineColor = UIManager.getColor("borderSecondary");
        this.marginLineColor = UIManager.getColor("borderSecondary");
        this.markOccurrencesBorder = true;
        this.matchedBracketBG = UIManager.getColor("textBackgroundSecondary");
        this.matchedBracketFG = UIManager.getColor("borderSecondary");
        this.matchedBracketHighlightBoth = true;
        this.matchedBracketAnimate = false;
        this.hyperlinkFG = UIManager.getColor("hyperlink");
        this.scheme = DarklafSyntaxScheme.getScheme(textArea.getSyntaxScheme(), LafManager.getTheme());
        this.gutterBackgroundColor = UIManager.getColor("textBackgroundSecondaryInactive");
        this.gutterBorderColor = UIManager.getColor("borderSecondary");
        this.activeLineRangeColor = UIManager.getColor("borderFocus");
        this.iconRowHeaderInheritsGutterBG = true;
        this.lineNumberColor = UIManager.getColor("textForegroundSecondary");
        Font baseNumberingFont = UIManager.getFont("NumberingPane.font");
        this.lineNumberFont = baseNumberingFont.getFamily();
        this.lineNumberFontSize = (int)Math.max(1.0f, textArea.getFont().getSize2D() - 2.0f);
        this.foldIndicatorFG = UIManager.getColor("borderSecondary");
        this.foldBG = UIManager.getColor("textBackgroundSecondary");
        this.armedFoldBG = UIManager.getColor("textBackgroundSecondaryInactive");
    }

    @Override
    public void apply(RSyntaxTextArea textArea) {
        this.updateTheme(textArea);
        super.apply(textArea);
        DarklafIconGroup iconGroup = new DarklafIconGroup(IconGroupDelegate.unwrap(RTextArea.getIconGroup()));
        RTextArea.setIconGroup(iconGroup);
        this.findItem(textArea, 1).setDisabledIcon(iconGroup.getIcon("cutDisabled"));
        this.findItem(textArea, 0).setDisabledIcon(iconGroup.getIcon("copyDisabled"));
        this.findItem(textArea, 3).setDisabledIcon(iconGroup.getIcon("pasteDisabled"));
        this.findItem(textArea, 2).setDisabledIcon(iconGroup.getIcon("deleteDisabled"));
        this.findItem(textArea, 6).setDisabledIcon(iconGroup.getIcon("undoDisabled"));
        this.findItem(textArea, 4).setDisabledIcon(iconGroup.getIcon("redoDisabled"));
    }

    private JMenuItem findItem(RSyntaxTextArea textArea, int actionId) {
        JPopupMenu popupMenu = textArea.getPopupMenu();
        RecordableTextAction action = RTextArea.getAction(actionId);
        for (Component c : popupMenu.getComponents()) {
            if (!(c instanceof JMenuItem) || ((JMenuItem)c).getAction() != action) continue;
            return (JMenuItem)c;
        }
        return new JMenuItem();
    }
}

