/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.util.Scale;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.Icon;

public class ScaledIcon
implements Icon {
    private final Image img;
    private final Component c;

    public ScaledIcon(Image img, Component c) {
        this.img = img;
        this.c = c;
    }

    @Override
    public void paintIcon(Component c, Graphics g2, int x, int y) {
        Graphics2D g = (Graphics2D)g2;
        g.translate(x, y);
        g.scale(1.0 / Scale.getScaleX(g), 1.0 / Scale.getScaleY(g));
        g.drawImage(this.img, 0, 0, this.img.getWidth(c), this.img.getHeight(c), c);
    }

    @Override
    public int getIconWidth() {
        return (int)((double)this.img.getWidth(this.c) / Scale.getScaleX(this.c.getGraphicsConfiguration()));
    }

    @Override
    public int getIconHeight() {
        return (int)((double)this.img.getHeight(this.c) / Scale.getScaleY(this.c.getGraphicsConfiguration()));
    }
}

