/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.parser;

import com.github.weisj.darklaf.color.ColorUtil;
import com.github.weisj.darklaf.parser.ParseResult;
import com.github.weisj.darklaf.parser.ParserContext;
import com.github.weisj.darklaf.parser.ParserUtil;
import com.github.weisj.darklaf.parser.PropertyParser;
import com.github.weisj.darklaf.uiresource.DarkColorUIResource;
import java.awt.Color;

public class PrimitiveParser
implements PropertyParser {
    public static final String COLOR_PREFIX = "#";
    public static final char STRING_DELIMITER = '\'';

    @Override
    public ParseResult doParse(ParseResult parseResult, ParserContext context) {
        if (parseResult.value.startsWith(COLOR_PREFIX)) {
            Color c = ColorUtil.fromHex(parseResult.value, null, true);
            ParserUtil.setNonNull(parseResult, c != null ? new DarkColorUIResource(c) : null);
        } else {
            Color c = ColorUtil.fromHex(parseResult.value, null, true);
            ParserUtil.setNonNull(parseResult, c != null ? new DarkColorUIResource(c) : null);
            if (parseResult.finished) {
                ParserUtil.warning("Declaration '" + parseResult.value + "' specifies a color  without a '#' prefix, which is deprecated. Support will be dropped in future versions.");
            }
        }
        if (parseResult.finished) {
            return parseResult;
        }
        if (ParserUtil.startsWith(parseResult, '\'')) {
            ParserUtil.setNonNull(parseResult, ParserUtil.parseBetween('\'', '\'', PropertyParser.of(String::valueOf), String.class, parseResult, context).orElse(null));
        }
        if (parseResult.finished) {
            return parseResult;
        }
        ParserUtil.setNonNull(parseResult, PrimitiveParser.getInteger(parseResult.value));
        if (parseResult.finished) {
            return parseResult;
        }
        ParserUtil.setNonNull(parseResult, this.getBoolean(parseResult.value));
        return parseResult;
    }

    private Boolean getBoolean(String value) {
        return "true".equalsIgnoreCase(value) ? Boolean.TRUE : ("false".equalsIgnoreCase(value) ? Boolean.FALSE : null);
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

