/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform;

import com.github.weisj.darklaf.platform.DefaultThemePreferenceProvider;
import com.github.weisj.darklaf.platform.macos.MacOSThemePreferenceProvider;
import com.github.weisj.darklaf.platform.windows.WindowsThemePreferenceProvider;
import com.github.weisj.darklaf.theme.event.ThemeEventSupport;
import com.github.weisj.darklaf.theme.event.ThemePreferenceChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemePreferenceListener;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.theme.info.ThemePreferenceProvider;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import javax.swing.SwingUtilities;

public class ThemePreferencesHandler {
    public static final String PREFERENCE_REPORTING_FLAG = "darklaf.enableNativePreferences";
    private static ThemePreferencesHandler sharedInstance;
    private final ThemeEventSupport<ThemePreferenceChangeEvent, ThemePreferenceListener> changeSupport = new ThemeEventSupport();
    private ThemePreferenceProvider preferenceProvider;

    public static ThemePreferencesHandler getSharedInstance() {
        if (sharedInstance == null) {
            ThemePreferencesHandler.setSharedInstance(new ThemePreferencesHandler());
        }
        return sharedInstance;
    }

    public static void setSharedInstance(ThemePreferencesHandler handler) {
        sharedInstance = handler;
    }

    protected ThemePreferencesHandler() {
        try {
            boolean enableNativePreferences = this.isNativePreferencesEnabled();
            this.preferenceProvider = SystemInfo.isWindows10 && enableNativePreferences ? new WindowsThemePreferenceProvider() : (SystemInfo.isMac && enableNativePreferences ? new MacOSThemePreferenceProvider() : new DefaultThemePreferenceProvider());
        }
        catch (Throwable e) {
            this.preferenceProvider = new DefaultThemePreferenceProvider();
        }
        this.preferenceProvider.initialize();
        this.preferenceProvider.setCallback(this::onChange);
    }

    private void onChange(PreferredThemeStyle style) {
        SwingUtilities.invokeLater(() -> this.changeSupport.dispatchEvent(new ThemePreferenceChangeEvent(style)));
    }

    public void addThemePreferenceChangeListener(ThemePreferenceListener listener) {
        this.changeSupport.addListener(listener);
    }

    public void removeThemePreferenceChangeListener(ThemePreferenceListener listener) {
        this.changeSupport.removeListener(listener);
    }

    public void enablePreferenceChangeReporting(boolean enabled) {
        this.preferenceProvider.setReporting(enabled);
    }

    private boolean isNativePreferencesEnabled() {
        return PropertyUtil.getSystemFlag(PREFERENCE_REPORTING_FLAG) && PropertyUtil.getSystemFlag("darklaf.allowNativeCode");
    }

    public boolean isPreferenceChangeReportingEnabled() {
        return this.preferenceProvider.canReport() && this.preferenceProvider.isReporting() && PropertyUtil.getSystemFlag(PREFERENCE_REPORTING_FLAG);
    }

    public boolean supportsNativeAccentColor() {
        return this.preferenceProvider.supportsNativeAccentColor();
    }

    public boolean supportsNativeSelectionColor() {
        return this.preferenceProvider.supportsNativeSelectionColor();
    }

    public boolean supportsNativeFontSize() {
        return this.preferenceProvider.supportsNativeFontSize();
    }

    public boolean supportsNativeTheme() {
        return this.preferenceProvider.supportsNativeTheme();
    }

    public PreferredThemeStyle getPreferredThemeStyle() {
        return this.preferenceProvider.getPreference();
    }

    public boolean canReport() {
        return this.preferenceProvider.canReport();
    }
}

