/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.swingdsl;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.swingdsl.laf.ComponentFactoryDelegate;
import com.github.weisj.swingdsl.laf.DefaultComponentFactory;
import com.github.weisj.swingdsl.laf.DefaultWrappedComponent;
import com.github.weisj.swingdsl.laf.StateValue;
import com.github.weisj.swingdsl.laf.WrappedComponent;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class DarklafComponentFactory
extends ComponentFactoryDelegate {
    public DarklafComponentFactory() {
        super(DefaultComponentFactory.create());
    }

    @Override
    @NotNull
    public WrappedComponent<JScrollPane> createScrollPane(@NotNull JComponent content) {
        OverlayScrollPane sp = new OverlayScrollPane(content);
        return new DefaultWrappedComponent<JScrollPane, OverlayScrollPane>(sp.getScrollPane(), sp);
    }

    @Override
    @NotNull
    public Color getBorderColor() {
        return UIManager.getColor("border");
    }

    @Override
    @NotNull
    public StateValue<Color> getDividerColor() {
        return new StateValue<Color>(UIManager.getColor("borderSecondary"), UIManager.getColor("widgetBorderInactive"));
    }

    @Override
    @NotNull
    public Color getHyperlinkColor() {
        return UIManager.getColor("hyperlink");
    }

    @Override
    @NotNull
    public Color getHyperlinkClickColor() {
        return UIManager.getColor("hyperlinkAccent");
    }

    @Override
    @NotNull
    public StateValue<Icon> getExpandedIcon() {
        return new StateValue<Icon>(DarkUIUtil.ICON_LOADER.getIcon("navigation/arrow/thick/arrowDown.svg"), DarkUIUtil.ICON_LOADER.getIcon("navigation/arrow/thick/arrowDownDisabled.svg"));
    }

    @Override
    @NotNull
    public StateValue<Icon> getCollapsedIcon() {
        return new StateValue<Icon>(DarkUIUtil.ICON_LOADER.getIcon("navigation/arrow/thick/arrowRight.svg"), DarkUIUtil.ICON_LOADER.getIcon("navigation/arrow/thick/arrowRightDisabled.svg"));
    }

    @Override
    @NotNull
    public Color getColorBackgroundColor() {
        return UIManager.getColor("backgroundColorful");
    }

    @Override
    @NotNull
    public Color getSecondaryTextForeground() {
        return UIManager.getColor("textForegroundSecondary");
    }

    @Override
    @NotNull
    public Color getWarningColor() {
        return UIManager.getColor("warningIconColor");
    }

    @Override
    @NotNull
    public Color getErrorColor() {
        return UIManager.getColor("errorIconColor");
    }
}

