/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.transfer;

import com.github.weisj.darklaf.icons.IconUtil;
import com.github.weisj.darklaf.transfer.ObjectTransferable;
import com.github.weisj.darklaf.util.Pair;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public final class TransferUtil {
    private TransferUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> Pair<DropTarget, AtomicBoolean> setupDnD(JComponent c, final int sourceActions, final Class<T> dataType, final Supplier<T> exporter, final Consumer<T> importer, final Function<T, Icon> dragImageCreator) {
        DragSource ds = new DragSource();
        AtomicBoolean dragEnabled = new AtomicBoolean(true);
        TransferHandler handler = new TransferHandler(){
            private final DataFlavor flavor;
            {
                try {
                    this.flavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + dataType.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public int getSourceActions(JComponent c) {
                return sourceActions;
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(this.flavor);
            }

            @Override
            public Icon getVisualRepresentation(Transferable t) {
                try {
                    return (Icon)dragImageCreator.apply(t.getTransferData(this.flavor));
                }
                catch (UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                Object value = exporter.get();
                this.setDragImage(IconUtil.iconToImage((Icon)dragImageCreator.apply(value), c));
                return new ObjectTransferable(value, dataType);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!support.isDrop()) {
                    return false;
                }
                try {
                    importer.accept(support.getTransferable().getTransferData(this.flavor));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        };
        c.setTransferHandler(handler);
        ds.createDefaultDragGestureRecognizer(c, sourceActions, dge -> {
            if (!dragEnabled.get()) {
                return;
            }
            handler.exportAsDrag(c, dge.getTriggerEvent(), dge.getDragAction());
        });
        return new Pair<DropTarget, AtomicBoolean>(c.getDropTarget(), dragEnabled);
    }
}

