/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.color.DarkColorModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DocumentFilter;

public final class ColorValueFormatter
extends JFormattedTextField.AbstractFormatter
implements FocusListener,
ActionListener {
    private final int fieldIndex;
    private final int radix;
    private final boolean hex;
    private final Timer errorTimer;
    private DarkColorModel model;
    private boolean transparencyEnabled;
    private JFormattedTextField text;
    private final DocumentFilter filter = new DocumentFilter(){

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (ColorValueFormatter.this.isValid(fb.getDocument().getLength() - length)) {
                fb.remove(offset, length);
                ColorValueFormatter.this.commit();
            } else {
                ColorValueFormatter.this.error();
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet set) throws BadLocationException {
            if (ColorValueFormatter.this.isValid(fb.getDocument().getLength() + text.length()) && ColorValueFormatter.this.isValid(text)) {
                StringBuilder newText = new StringBuilder(fb.getDocument().getText(0, fb.getDocument().getLength()));
                newText.insert(offset, text);
                if (ColorValueFormatter.this.hex || ColorValueFormatter.this.isValidValue(newText.toString())) {
                    fb.insertString(offset, text.toUpperCase(Locale.ENGLISH), set);
                    ColorValueFormatter.this.commit();
                    return;
                }
            }
            ColorValueFormatter.this.error();
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet set) throws BadLocationException {
            if (ColorValueFormatter.this.isValid(fb.getDocument().getLength() + text.length() - length) && ColorValueFormatter.this.isValid(text)) {
                StringBuilder newText = new StringBuilder(fb.getDocument().getText(0, fb.getDocument().getLength()));
                newText.replace(offset, offset + length, text);
                if (ColorValueFormatter.this.hex || ColorValueFormatter.this.isValidValue(newText.toString())) {
                    fb.replace(offset, length, text.toUpperCase(Locale.ENGLISH), set);
                    ColorValueFormatter.this.commit();
                    return;
                }
            }
            ColorValueFormatter.this.error();
        }
    };

    private ColorValueFormatter(DarkColorModel model, int index, boolean hex) {
        this.model = model;
        this.fieldIndex = index;
        this.radix = hex ? 16 : 10;
        this.hex = hex;
        this.errorTimer = new Timer(UIManager.getInt("ColorChooser.errorDelay"), this);
        this.errorTimer.setRepeats(false);
    }

    public static ColorValueFormatter init(DarkColorModel model, int index, boolean hex, JFormattedTextField text) {
        ColorValueFormatter formatter = new ColorValueFormatter(model, index, hex);
        formatter.setText(text);
        text.setFormatterFactory(new DefaultFormatterFactory(formatter));
        text.setMinimumSize(text.getPreferredSize());
        text.addFocusListener(formatter);
        return formatter;
    }

    public void setText(JFormattedTextField text) {
        this.text = text;
    }

    protected void error() {
        this.text.putClientProperty("JTextComponent.hasError", true);
        this.text.repaint();
        this.errorTimer.restart();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.text.putClientProperty("JTextComponent.hasError", false);
        this.text.repaint();
    }

    private void commit() {
        this.text.putClientProperty("JTextComponent.hasError", false);
        this.text.repaint();
        SwingUtilities.invokeLater(() -> {
            try {
                if (this.text != null) {
                    this.text.commitEdit();
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
    }

    public void setModel(DarkColorModel model) {
        this.model = model;
    }

    public void setTransparencyEnabled(boolean transparencyEnabled) {
        this.transparencyEnabled = transparencyEnabled;
    }

    @Override
    public void focusGained(FocusEvent event) {
        Object source2 = event.getSource();
        if (source2 instanceof JFormattedTextField) {
            this.text = (JFormattedTextField)source2;
            SwingUtilities.invokeLater(() -> {
                if (this.text != null) {
                    this.text.selectAll();
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        SwingUtilities.invokeLater(() -> this.text.select(0, 0));
    }

    private boolean isValid(int length) {
        return 0 <= length && length <= this.getLength();
    }

    private int getLength() {
        return this.hex ? this.getHexLength() : String.valueOf(this.model.getMaximum(this.fieldIndex)).length();
    }

    private int getHexLength() {
        return this.transparencyEnabled ? 8 : 6;
    }

    private boolean isValid(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (Character.digit(ch, this.radix) >= 0) continue;
            return false;
        }
        return true;
    }

    private boolean isValidValue(String text) {
        try {
            this.stringToValue(text);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        try {
            if (text.isEmpty()) {
                return this.model.getDefault(this.fieldIndex);
            }
            if (this.hex) {
                String hexStr = String.format("%1$-" + this.getHexLength() + "s", text).replaceAll(" ", "F");
                int r = Integer.valueOf(hexStr.substring(0, 2), 16);
                this.checkRange(r, 0, 255);
                int g = Integer.valueOf(hexStr.substring(2, 4), 16);
                this.checkRange(g, 0, 255);
                int b = Integer.valueOf(hexStr.substring(4, 6), 16);
                this.checkRange(b, 0, 255);
                int alpha = hexStr.length() >= 8 ? Integer.valueOf(hexStr.substring(6, 8), 16) : 255;
                this.checkRange(alpha, 0, 255);
                return new Color(r, g, b, alpha);
            }
            int value = Integer.valueOf(text, this.radix);
            int min = this.model.getMinimum(this.fieldIndex);
            int max = this.model.getMaximum(this.fieldIndex);
            this.checkRange(value, min, max);
            return value;
        }
        catch (NumberFormatException nfe) {
            ParseException pe = new ParseException("illegal format", 0);
            pe.initCause(nfe);
            throw pe;
        }
    }

    protected void checkRange(int value, int min, int max) throws ParseException {
        if (value > max || value < min) {
            throw new ParseException("Value not in range [" + min + "," + max + "]", 0);
        }
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        if (object instanceof Integer && !this.hex) {
            return object.toString();
        }
        if (object instanceof Color && this.hex) {
            Color c = (Color)object;
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            int a = c.getAlpha();
            if (this.getHexLength() == 8) {
                return String.format("%02X%02X%02X%02X", r, g, b, a);
            }
            return String.format("%02X%02X%02X", r, g, b);
        }
        throw new ParseException("illegal object", 0);
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.filter;
    }
}

