/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;

public final class FindOptions {
    public static final String LIMIT_KEY = "limit";
    public static final String OFFSET_KEY = "offset";
    public static final String SORT_BY_KEY = "sortBy";
    public static final String DESCENDING_KEY = "descending";
    public static final String AFTER_KEY = "after";
    private Integer limit;
    private Integer offset;
    private String sortBy;
    private Boolean descending;
    private String after;

    @Nonnull
    public static FindOptions create(@Nullable String link) {
        String after;
        String descending;
        String sortBy;
        String offset;
        FindOptions options = new FindOptions();
        if (link == null) {
            return options;
        }
        HttpUrl httpUrl = HttpUrl.parse("https://influxdb" + link);
        if (httpUrl == null) {
            return options;
        }
        Set<String> qp = httpUrl.queryParameterNames();
        if (!(qp.contains(LIMIT_KEY) || qp.contains(OFFSET_KEY) || qp.contains(SORT_BY_KEY) || qp.contains(DESCENDING_KEY) || qp.contains(AFTER_KEY))) {
            return options;
        }
        String limit = httpUrl.queryParameter(LIMIT_KEY);
        if (limit != null) {
            options.setLimit(Integer.valueOf(limit));
        }
        if ((offset = httpUrl.queryParameter(OFFSET_KEY)) != null) {
            options.setOffset(Integer.valueOf(offset));
        }
        if ((sortBy = httpUrl.queryParameter(SORT_BY_KEY)) != null) {
            options.setSortBy(sortBy);
        }
        if ((descending = httpUrl.queryParameter(DESCENDING_KEY)) != null) {
            options.setDescending(Boolean.valueOf(descending));
        }
        if ((after = httpUrl.queryParameter(AFTER_KEY)) != null) {
            options.setAfter(after);
        }
        return options;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public Boolean getDescending() {
        return this.descending;
    }

    public void setDescending(Boolean descending) {
        this.descending = descending;
    }

    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }
}

