/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.ArrayExpression;
import com.influxdb.client.domain.BinaryExpression;
import com.influxdb.client.domain.Block;
import com.influxdb.client.domain.BooleanLiteral;
import com.influxdb.client.domain.CallExpression;
import com.influxdb.client.domain.ConditionalExpression;
import com.influxdb.client.domain.DateTimeLiteral;
import com.influxdb.client.domain.DictExpression;
import com.influxdb.client.domain.DurationLiteral;
import com.influxdb.client.domain.Expression;
import com.influxdb.client.domain.FloatLiteral;
import com.influxdb.client.domain.Identifier;
import com.influxdb.client.domain.IndexExpression;
import com.influxdb.client.domain.IntegerLiteral;
import com.influxdb.client.domain.LogicalExpression;
import com.influxdb.client.domain.MemberExpression;
import com.influxdb.client.domain.Node;
import com.influxdb.client.domain.ObjectExpression;
import com.influxdb.client.domain.ParenExpression;
import com.influxdb.client.domain.PipeExpression;
import com.influxdb.client.domain.PipeLiteral;
import com.influxdb.client.domain.Property;
import com.influxdb.client.domain.RegexpLiteral;
import com.influxdb.client.domain.StringLiteral;
import com.influxdb.client.domain.UnaryExpression;
import com.influxdb.client.domain.UnsignedIntegerLiteral;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FunctionExpression
extends Expression {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_PARAMS = "params";
    @SerializedName(value="params")
    private List<Property> params = new ArrayList<Property>();
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    @JsonAdapter(value=FunctionExpressionBodyAdapter.class)
    private Node body = null;

    public FunctionExpression type(String type) {
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FunctionExpression params(List<Property> params) {
        this.params = params;
        return this;
    }

    public FunctionExpression addParamsItem(Property paramsItem) {
        if (this.params == null) {
            this.params = new ArrayList<Property>();
        }
        this.params.add(paramsItem);
        return this;
    }

    public List<Property> getParams() {
        return this.params;
    }

    public void setParams(List<Property> params) {
        this.params = params;
    }

    public FunctionExpression body(Node body) {
        this.body = body;
        return this;
    }

    public Node getBody() {
        return this.body;
    }

    public void setBody(Node body) {
        this.body = body;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionExpression functionExpression = (FunctionExpression)o;
        return Objects.equals(this.type, functionExpression.type) && Objects.equals(this.params, functionExpression.params) && Objects.equals(this.body, functionExpression.body) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.params, this.body, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunctionExpression {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class FunctionExpressionBodyAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        @Override
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList(FunctionExpression.SERIALIZED_NAME_TYPE);
            JsonObject jsonObject = json.getAsJsonObject();
            String[] types = (String[])discriminator.stream().map(jsonObject::get).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);
            return this.deserialize(types, jsonObject, context);
        }

        @Override
        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"ArrayExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ArrayExpression.class));
            }
            if (Arrays.equals(new String[]{"DictExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)DictExpression.class));
            }
            if (Arrays.equals(new String[]{"FunctionExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)FunctionExpression.class));
            }
            if (Arrays.equals(new String[]{"BinaryExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)BinaryExpression.class));
            }
            if (Arrays.equals(new String[]{"CallExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)CallExpression.class));
            }
            if (Arrays.equals(new String[]{"ConditionalExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ConditionalExpression.class));
            }
            if (Arrays.equals(new String[]{"LogicalExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)LogicalExpression.class));
            }
            if (Arrays.equals(new String[]{"MemberExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)MemberExpression.class));
            }
            if (Arrays.equals(new String[]{"IndexExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)IndexExpression.class));
            }
            if (Arrays.equals(new String[]{"ObjectExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ObjectExpression.class));
            }
            if (Arrays.equals(new String[]{"ParenExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ParenExpression.class));
            }
            if (Arrays.equals(new String[]{"PipeExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)PipeExpression.class));
            }
            if (Arrays.equals(new String[]{"UnaryExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)UnaryExpression.class));
            }
            if (Arrays.equals(new String[]{"BooleanLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)BooleanLiteral.class));
            }
            if (Arrays.equals(new String[]{"DateTimeLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)DateTimeLiteral.class));
            }
            if (Arrays.equals(new String[]{"DurationLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)DurationLiteral.class));
            }
            if (Arrays.equals(new String[]{"FloatLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)FloatLiteral.class));
            }
            if (Arrays.equals(new String[]{"IntegerLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)IntegerLiteral.class));
            }
            if (Arrays.equals(new String[]{"PipeLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)PipeLiteral.class));
            }
            if (Arrays.equals(new String[]{"RegexpLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)RegexpLiteral.class));
            }
            if (Arrays.equals(new String[]{"StringLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)StringLiteral.class));
            }
            if (Arrays.equals(new String[]{"UnsignedIntegerLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)UnsignedIntegerLiteral.class));
            }
            if (Arrays.equals(new String[]{"Identifier"}, types)) {
                return context.deserialize(json, (Type)((Object)Identifier.class));
            }
            if (Arrays.equals(new String[]{"Block"}, types)) {
                return context.deserialize(json, (Type)((Object)Block.class));
            }
            return context.deserialize(json, (Type)((Object)Object.class));
        }
    }
}

