/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.NotificationEndpoint;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HTTPNotificationEndpoint
extends NotificationEndpoint {
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_METHOD = "method";
    @SerializedName(value="method")
    private MethodEnum method;
    public static final String SERIALIZED_NAME_AUTH_METHOD = "authMethod";
    @SerializedName(value="authMethod")
    private AuthMethodEnum authMethod;
    public static final String SERIALIZED_NAME_CONTENT_TEMPLATE = "contentTemplate";
    @SerializedName(value="contentTemplate")
    private String contentTemplate;
    public static final String SERIALIZED_NAME_HEADERS = "headers";
    @SerializedName(value="headers")
    private Map<String, String> headers = new HashMap<String, String>();

    public HTTPNotificationEndpoint url(String url) {
        this.url = url;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HTTPNotificationEndpoint username(String username) {
        this.username = username;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public HTTPNotificationEndpoint password(String password) {
        this.password = password;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public HTTPNotificationEndpoint token(String token) {
        this.token = token;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public HTTPNotificationEndpoint method(MethodEnum method) {
        this.method = method;
        return this;
    }

    public MethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public HTTPNotificationEndpoint authMethod(AuthMethodEnum authMethod) {
        this.authMethod = authMethod;
        return this;
    }

    public AuthMethodEnum getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(AuthMethodEnum authMethod) {
        this.authMethod = authMethod;
    }

    public HTTPNotificationEndpoint contentTemplate(String contentTemplate) {
        this.contentTemplate = contentTemplate;
        return this;
    }

    public String getContentTemplate() {
        return this.contentTemplate;
    }

    public void setContentTemplate(String contentTemplate) {
        this.contentTemplate = contentTemplate;
    }

    public HTTPNotificationEndpoint headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HTTPNotificationEndpoint putHeadersItem(String key, String headersItem) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, headersItem);
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPNotificationEndpoint htTPNotificationEndpoint = (HTTPNotificationEndpoint)o;
        return Objects.equals(this.url, htTPNotificationEndpoint.url) && Objects.equals(this.username, htTPNotificationEndpoint.username) && Objects.equals(this.password, htTPNotificationEndpoint.password) && Objects.equals(this.token, htTPNotificationEndpoint.token) && Objects.equals((Object)this.method, (Object)htTPNotificationEndpoint.method) && Objects.equals((Object)this.authMethod, (Object)htTPNotificationEndpoint.authMethod) && Objects.equals(this.contentTemplate, htTPNotificationEndpoint.contentTemplate) && Objects.equals(this.headers, htTPNotificationEndpoint.headers) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.username, this.password, this.token, this.method, this.authMethod, this.contentTemplate, this.headers, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HTTPNotificationEndpoint {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    authMethod: ").append(this.toIndentedString((Object)this.authMethod)).append("\n");
        sb.append("    contentTemplate: ").append(this.toIndentedString(this.contentTemplate)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AuthMethodEnum {
        NONE("none"),
        BASIC("basic"),
        BEARER("bearer");

        private String value;

        private AuthMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AuthMethodEnum fromValue(String text) {
            for (AuthMethodEnum b : AuthMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AuthMethodEnum> {
            @Override
            public void write(JsonWriter jsonWriter, AuthMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public AuthMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AuthMethodEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MethodEnum {
        POST("POST"),
        GET("GET"),
        PUT("PUT");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MethodEnum fromValue(String text) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MethodEnum> {
            @Override
            public void write(JsonWriter jsonWriter, MethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public MethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MethodEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

