/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Cancellable;
import com.influxdb.client.InfluxQLQueryApi;
import com.influxdb.client.domain.InfluxQLQuery;
import com.influxdb.client.service.InfluxQLQueryService;
import com.influxdb.internal.AbstractQueryApi;
import com.influxdb.query.InfluxQLQueryResult;
import com.influxdb.utils.Arguments;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import retrofit2.Call;

public class InfluxQLQueryApiImpl
extends AbstractQueryApi
implements InfluxQLQueryApi {
    private final InfluxQLQueryService service;

    public InfluxQLQueryApiImpl(@Nonnull InfluxQLQueryService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public InfluxQLQueryResult query(@Nonnull InfluxQLQuery influxQlQuery) {
        return this.query(influxQlQuery, null);
    }

    @Override
    @Nonnull
    public InfluxQLQueryResult query(@Nonnull InfluxQLQuery influxQlQuery, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) {
        Call<ResponseBody> call = this.service.query(influxQlQuery.getCommand(), influxQlQuery.getDatabase(), influxQlQuery.getRetentionPolicy(), influxQlQuery.getPrecision() != null ? influxQlQuery.getPrecision().getSymbol() : null, null);
        AtomicReference atomicReference = new AtomicReference();
        BiConsumer<Cancellable, BufferedSource> consumer = (cancellable, bufferedSource) -> {
            try {
                InfluxQLQueryResult result = this.parseResponse((BufferedSource)bufferedSource, (Cancellable)cancellable, valueExtractor);
                atomicReference.set(result);
            }
            catch (IOException e) {
                ERROR_CONSUMER.accept(e);
            }
        };
        this.query(call, consumer, (Consumer<? super Throwable>)ERROR_CONSUMER, EMPTY_ACTION, (Boolean)false);
        return (InfluxQLQueryResult)atomicReference.get();
    }

    private InfluxQLQueryResult parseResponse(@Nonnull BufferedSource bufferedSource, @Nonnull Cancellable cancellable, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) throws IOException {
        Arguments.checkNotNull(bufferedSource, "bufferedSource");
        try (InputStreamReader reader = new InputStreamReader(bufferedSource.inputStream(), StandardCharsets.UTF_8);){
            InfluxQLQueryResult influxQLQueryResult = InfluxQLQueryApiImpl.readInfluxQLResult(reader, cancellable, valueExtractor);
            return influxQLQueryResult;
        }
    }

    static InfluxQLQueryResult readInfluxQLResult(@Nonnull Reader reader, @Nonnull Cancellable cancellable, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) throws IOException {
        ArrayList<InfluxQLQueryResult.Result> results = new ArrayList<InfluxQLQueryResult.Result>();
        LinkedHashMap<List, InfluxQLQueryResult.Series> series = null;
        LinkedHashMap<String, Integer> headerCols = null;
        boolean nameCol = false;
        boolean tagsCol = true;
        int dynamicColumnsStartIndex = 2;
        try (CSVParser parser = new CSVParser(reader, CSVFormat.DEFAULT.builder().setIgnoreEmptyLines(false).build());){
            for (CSVRecord csvRecord : parser) {
                if (cancellable.isCancelled()) {
                    break;
                }
                int resultIndex = results.size();
                if (csvRecord.size() == 1 || csvRecord.get(0).equals("")) {
                    if (series != null) {
                        InfluxQLQueryResult.Result result = new InfluxQLQueryResult.Result(resultIndex, new ArrayList<InfluxQLQueryResult.Series>(series.values()));
                        results.add(result);
                    }
                    series = null;
                    continue;
                }
                if (series == null) {
                    List<String> header = csvRecord.toList();
                    headerCols = new LinkedHashMap<String, Integer>();
                    for (int col = 2; col < header.size(); ++col) {
                        String colName = header.get(col);
                        headerCols.put(colName, col - 2);
                    }
                    series = new LinkedHashMap<List, InfluxQLQueryResult.Series>();
                    continue;
                }
                String name = csvRecord.get(0);
                Map<String, String> finalTags = InfluxQLQueryApiImpl.parseTags(csvRecord.get(1));
                LinkedHashMap<String, Integer> finalHeaderCols = headerCols;
                InfluxQLQueryResult.Series serie = series.computeIfAbsent(Arrays.asList(name, finalTags), n -> new InfluxQLQueryResult.Series(name, finalTags, finalHeaderCols));
                Object[] values = headerCols.entrySet().stream().map(entry -> {
                    String value = csvRecord.get((Integer)entry.getValue() + 2);
                    if (valueExtractor != null) {
                        return valueExtractor.extractValue((String)entry.getKey(), value, resultIndex, serie.getName());
                    }
                    return value;
                }).toArray();
                InfluxQLQueryResult.Series series2 = serie;
                series2.getClass();
                InfluxQLQueryResult.Series.Record record = new InfluxQLQueryResult.Series.Record(series2, values);
                serie.addRecord(record);
            }
        }
        if (series != null) {
            InfluxQLQueryResult.Result result = new InfluxQLQueryResult.Result(results.size(), new ArrayList<InfluxQLQueryResult.Series>(series.values()));
            results.add(result);
        }
        return new InfluxQLQueryResult(results);
    }

    private static Map<String, String> parseTags(@Nonnull String value) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (value.length() > 0) {
            for (String entry : value.split(",")) {
                String[] kv = entry.split("=");
                tags.put(kv[0], kv[1]);
            }
        }
        return tags;
    }
}

