/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Cancellable;
import com.influxdb.client.InvokableScriptsApi;
import com.influxdb.client.InvokableScriptsQuery;
import com.influxdb.client.domain.Script;
import com.influxdb.client.domain.ScriptCreateRequest;
import com.influxdb.client.domain.ScriptInvocationParams;
import com.influxdb.client.domain.ScriptUpdateRequest;
import com.influxdb.client.domain.Scripts;
import com.influxdb.client.service.InvokableScriptsService;
import com.influxdb.internal.AbstractQueryApi;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import com.influxdb.query.internal.FluxCsvParser;
import com.influxdb.utils.Arguments;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import retrofit2.Call;

final class InvokableScriptsApiImpl
extends AbstractQueryApi
implements InvokableScriptsApi {
    private final InvokableScriptsService service;

    InvokableScriptsApiImpl(@Nonnull InvokableScriptsService service) {
        super(new FluxCsvParser(FluxCsvParser.ResponseMetadataMode.ONLY_NAMES));
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Script createScript(@Nonnull ScriptCreateRequest createRequest) {
        Arguments.checkNotNull(createRequest, "createRequest");
        Call<Script> call = this.service.postScripts(createRequest);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Script updateScript(@Nonnull String scriptId, @Nonnull ScriptUpdateRequest updateRequest) {
        Arguments.checkNonEmpty(scriptId, "scriptId");
        Arguments.checkNotNull(updateRequest, "updateRequest");
        Call<Script> call = this.service.patchScriptsID(scriptId, updateRequest);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<Script> findScripts() {
        return this.findScripts(new InvokableScriptsQuery());
    }

    @Override
    @Nonnull
    public List<Script> findScripts(@Nonnull InvokableScriptsQuery query) {
        Arguments.checkNotNull(query, "query");
        Call<Scripts> call = this.service.getScripts(query.getLimit(), query.getOffset());
        return this.execute(call).getScripts();
    }

    @Override
    public void deleteScript(@Nonnull String scriptId) {
        Arguments.checkNonEmpty(scriptId, "scriptId");
        Call<Void> call = this.service.deleteScriptsID(scriptId);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<FluxTable> invokeScript(@Nonnull String scriptId, @Nullable Map<String, Object> params) {
        Arguments.checkNonEmpty(scriptId, "scriptId");
        FluxCsvParser.FluxResponseConsumerTable consumer = new FluxCsvParser.FluxResponseConsumerTable(this.fluxCsvParser);
        this.query(scriptId, params, consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return consumer.getTables();
    }

    @Override
    public void invokeScript(@Nonnull String scriptId, @Nullable Map<String, Object> params, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext) {
        this.invokeScript(scriptId, params, onNext, ERROR_CONSUMER, EMPTY_ACTION);
    }

    @Override
    public void invokeScript(@Nonnull String scriptId, @Nullable Map<String, Object> params, final @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(onNext, "onNext");
        FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            }

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                onNext.accept(cancellable, record);
            }
        };
        this.query(scriptId, params, consumer, onError, onComplete, true);
    }

    @Override
    @Nonnull
    public <M> List<M> invokeScript(@Nonnull String scriptId, @Nullable Map<String, Object> params, final @Nonnull Class<M> measurementType) {
        final ArrayList measurements = new ArrayList();
        FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            }

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                measurements.add(InvokableScriptsApiImpl.this.resultMapper.toPOJO(record, measurementType));
            }
        };
        this.query(scriptId, params, consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return measurements;
    }

    @Override
    public <M> void invokeScript(@Nonnull String scriptId, @Nullable Map<String, Object> params, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext) {
        this.invokeScript(scriptId, params, measurementType, onNext, ERROR_CONSUMER, EMPTY_ACTION);
    }

    @Override
    public <M> void invokeScript(@Nonnull String scriptId, @Nullable Map<String, Object> params, final @Nonnull Class<M> measurementType, final @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(onNext, "onNext");
        FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            }

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                onNext.accept(cancellable, InvokableScriptsApiImpl.this.resultMapper.toPOJO(record, measurementType));
            }
        };
        this.query(scriptId, params, consumer, onError, onComplete, true);
    }

    @Override
    @Nonnull
    public String invokeScriptRaw(@Nonnull String scriptId, @Nullable Map<String, Object> params) {
        ArrayList rows = new ArrayList();
        BiConsumer<Cancellable, String> consumer = (cancellable, row) -> rows.add(row);
        this.queryRaw(scriptId, params, consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return String.join((CharSequence)"\n", rows);
    }

    @Override
    public void invokeScriptRaw(@Nonnull String scriptId, @Nullable Map<String, Object> params, @Nonnull BiConsumer<Cancellable, String> onResponse) {
        this.invokeScriptRaw(scriptId, params, onResponse, ERROR_CONSUMER, EMPTY_ACTION);
    }

    @Override
    public void invokeScriptRaw(@Nonnull String scriptId, @Nullable Map<String, Object> params, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        this.queryRaw(scriptId, params, onResponse, onError, onComplete, true);
    }

    private void query(@Nonnull String scriptId, @Nullable Map<String, Object> params, @Nonnull FluxCsvParser.FluxResponseConsumer responseConsumer, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        Arguments.checkNonEmpty(scriptId, "scriptId");
        Arguments.checkNotNull(responseConsumer, "responseConsumer");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(onComplete, "onComplete");
        Arguments.checkNotNull(asynchronously, "asynchronously");
        Call<ResponseBody> queryCall = this.service.postScriptsIDInvokeResponseBody(scriptId, new ScriptInvocationParams().params(params));
        this.query(queryCall, responseConsumer, onError, onComplete, asynchronously);
    }

    private void queryRaw(@Nonnull String scriptId, @Nullable Map<String, Object> params, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        Arguments.checkNonEmpty(scriptId, "scriptId");
        Arguments.checkNotNull(onResponse, "onResponse");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(onComplete, "onComplete");
        Arguments.checkNotNull(asynchronously, "asynchronously");
        Call<ResponseBody> queryCall = this.service.postScriptsIDInvokeResponseBody(scriptId, new ScriptInvocationParams().params(params));
        this.queryRaw(queryCall, onResponse, onError, onComplete, asynchronously);
    }
}

