/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal.flowable;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableInternalHelper;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.subscribers.LambdaSubscriber;
import io.reactivex.rxjava3.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferTimedFlushable<T, U extends List<? super T>>
extends Flowable<U>
implements FlowableTransformer<T, U> {
    final Publisher<T> source;
    final Publisher<Boolean> flusher;
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Supplier<U> bufferSupplier;
    final int maxSize;
    final boolean restartTimerOnMaxSize;

    public FlowableBufferTimedFlushable(Publisher<T> source2, Publisher<Boolean> flusher, long timespan, TimeUnit unit, int maxSize, Scheduler scheduler, Supplier<U> bufferSupplier) {
        this.source = source2;
        this.flusher = flusher;
        this.timespan = timespan;
        this.timeskip = timespan;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSupplier = bufferSupplier;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = true;
    }

    @Override
    @NonNull
    public Publisher<U> apply(@NonNull Flowable<T> upstream) {
        return new FlowableBufferTimedFlushable<T, U>(upstream, this.flusher, this.timeskip, this.unit, this.maxSize, this.scheduler, this.bufferSupplier);
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super U> subscriber) {
        Scheduler.Worker w = this.scheduler.createWorker();
        this.source.subscribe(new BufferExactBoundedSubscriber(new SerializedSubscriber<U>(subscriber), this.bufferSupplier, this.timespan, this.unit, this.maxSize, this.restartTimerOnMaxSize, w, this.flusher));
    }

    static final class BufferExactBoundedSubscriber<T, U extends Collection<? super T>>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Runnable,
    Disposable {
        final Supplier<U> bufferSupplier;
        final long timespan;
        final TimeUnit unit;
        final int maxSize;
        final boolean restartTimerOnMaxSize;
        final Scheduler.Worker w;
        final Publisher<Boolean> flusher;
        U buffer;
        Disposable timer;
        Subscription upstream;
        long producerIndex;
        long consumerIndex;

        BufferExactBoundedSubscriber(Subscriber<? super U> actual, Supplier<U> bufferSupplier, long timespan, TimeUnit unit, int maxSize, boolean restartOnMaxSize, Scheduler.Worker w, Publisher<Boolean> flusher) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.unit = unit;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartOnMaxSize;
            this.w = w;
            this.flusher = flusher;
        }

        @Override
        public void onSubscribe(@NonNull Subscription s) {
            Collection b;
            if (!SubscriptionHelper.validate(this.upstream, s)) {
                return;
            }
            this.upstream = s;
            try {
                b = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.w.dispose();
                s.cancel();
                EmptySubscription.error(e, this.downstream);
                return;
            }
            this.buffer = b;
            this.downstream.onSubscribe(this);
            this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            s.request(Long.MAX_VALUE);
            this.flusher.subscribe(new LambdaSubscriber<Boolean>(ignore -> this.run(), Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION, FlowableInternalHelper.RequestMax.INSTANCE));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            Object b;
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
                if (b.size() < this.maxSize) {
                    return;
                }
                this.buffer = null;
                ++this.producerIndex;
            }
            if (this.restartTimerOnMaxSize) {
                this.timer.dispose();
            }
            this.fastPathOrderedEmitMax(b, false, this);
            try {
                b = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.downstream.onError(e);
                return;
            }
            bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                this.buffer = b;
                ++this.consumerIndex;
            }
            if (this.restartTimerOnMaxSize) {
                this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                this.buffer = null;
            }
            this.downstream.onError(t);
            this.w.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                b = this.buffer;
                this.buffer = null;
            }
            if (b != null) {
                this.queue.offer(b);
                this.done = true;
                if (this.enter()) {
                    QueueDrainHelper.drainMaxLoop(this.queue, this.downstream, false, this, this);
                }
                this.w.dispose();
            }
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            a.onNext(v);
            return true;
        }

        @Override
        public void request(long n) {
            this.requested(n);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                this.buffer = null;
            }
            this.upstream.cancel();
            this.w.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.w.isDisposed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            U current;
            Collection next;
            try {
                next = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.downstream.onError(e);
                return;
            }
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                current = this.buffer;
                if (current == null || this.producerIndex != this.consumerIndex) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathOrderedEmitMax(current, false, this);
        }
    }
}

