/*
 * Decompiled with CFR 0.152.
 */
package io.github.mderevyankoaqa.influxdb2.visualizer;

import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import io.github.mderevyankoaqa.influxdb2.visualizer.config.InfluxDBConfig;
import io.github.mderevyankoaqa.influxdb2.visualizer.influxdb.client.InfluxDatabaseClient;
import io.github.mderevyankoaqa.influxdb2.visualizer.result.SampleResultPointContext;
import io.github.mderevyankoaqa.influxdb2.visualizer.result.SampleResultPointProvider;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.visualizers.backend.AbstractBackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDatabaseBackendListenerClient
extends AbstractBackendListenerClient
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxDatabaseBackendListenerClient.class);
    private static final String KEY_USE_REGEX_FOR_SAMPLER_LIST = "useRegexForSamplerList";
    private static final String KEY_TEST_NAME = "testName";
    private static final String KEY_RUN_ID = "runId";
    private static final String KEY_INCLUDE_BODY_OF_FAILURES = "saveResponseBodyOfFailures";
    private static final String KEY_NODE_NAME = "nodeName";
    private static final String KEY_SAMPLERS_LIST = "samplersList";
    private static final String KEY_RECORD_SUB_SAMPLES = "recordSubSamples";
    private final WritePrecision writePrecision = WritePrecision.MS;
    private static final String SEPARATOR = ";";
    private static final int ONE_MS_IN_NANOSECONDS = 1000000;
    private ScheduledThreadPoolExecutor scheduler;
    private String testName;
    private String runId;
    private String nodeName;
    private String regexForSamplerList;
    private Set<String> samplersToFilter;
    private SecureRandom randomNumberGenerator;
    private boolean recordSubSamples;
    private InfluxDBConfig influxDBConfig;
    private Timer timer;
    private ScheduledFuture<?> scheduledFuture;

    @Override
    public void handleSampleResults(List<SampleResult> sampleResults, BackendListenerContext context) {
        ArrayList<SampleResult> allSampleResults = new ArrayList<SampleResult>();
        for (SampleResult sampleResult : sampleResults) {
            allSampleResults.add(sampleResult);
            if (!this.recordSubSamples) continue;
            Collections.addAll(allSampleResults, sampleResult.getSubResults());
        }
        for (SampleResult sampleResult : allSampleResults) {
            this.getUserMetrics().add(sampleResult);
            String samplerType = "transaction";
            if (sampleResult instanceof HTTPSampleResult) {
                samplerType = "request";
            }
            if ((null == this.regexForSamplerList || !sampleResult.getSampleLabel().matches(this.regexForSamplerList)) && !this.samplersToFilter.contains(sampleResult.getSampleLabel())) continue;
            SampleResultPointContext sampleResultContext = new SampleResultPointContext();
            sampleResultContext.setRunId(this.runId);
            sampleResultContext.setTestName(this.testName);
            sampleResultContext.setNodeName(this.nodeName);
            sampleResultContext.setSampleResult(sampleResult);
            sampleResultContext.setSamplerType(samplerType);
            sampleResultContext.setTimeToSet(System.currentTimeMillis() * 1000000L + (long)this.getUniqueNumberForTheSamplerThread());
            sampleResultContext.setErrorBodyToBeSaved(context.getBooleanParameter(KEY_INCLUDE_BODY_OF_FAILURES, false));
            sampleResultContext.setResponseBodyLength(this.influxDBConfig.getResponseBodyLength());
            SampleResultPointProvider sampleResultPointProvider = new SampleResultPointProvider(sampleResultContext);
            Point resultPoint = sampleResultPointProvider.getPoint();
            InfluxDatabaseClient.getInstance(this.influxDBConfig, LOGGER).collectData(resultPoint);
        }
    }

    @Override
    public Arguments getDefaultParameters() {
        Arguments arguments = new Arguments();
        arguments.addArgument(KEY_TEST_NAME, "Test");
        arguments.addArgument(KEY_NODE_NAME, "Test-Node");
        arguments.addArgument(KEY_RUN_ID, "R001");
        arguments.addArgument("influxDBURL", "http://localhost:8086/");
        arguments.addArgument("influxDBToken", "put token here");
        arguments.addArgument("influxDBOrganization", "performance_testing");
        arguments.addArgument("influxDBBucket", "jmeter");
        arguments.addArgument("influxDBFlushInterval", Integer.toString(4000));
        arguments.addArgument("influxDBMaxBatchSize", Integer.toString(2000));
        arguments.addArgument("influxDBThresholdError", Integer.toString(5));
        arguments.addArgument(KEY_SAMPLERS_LIST, ".*");
        arguments.addArgument(KEY_USE_REGEX_FOR_SAMPLER_LIST, "true");
        arguments.addArgument(KEY_RECORD_SUB_SAMPLES, "true");
        arguments.addArgument(KEY_INCLUDE_BODY_OF_FAILURES, "true");
        arguments.addArgument("responseBodyLength", Integer.toString(2000));
        return arguments;
    }

    @Override
    public void setupTest(BackendListenerContext context) {
        this.testName = context.getParameter(KEY_TEST_NAME, "Test");
        this.runId = context.getParameter(KEY_RUN_ID, "R001");
        this.randomNumberGenerator = new SecureRandom();
        this.nodeName = context.getParameter(KEY_NODE_NAME, "Test-Node");
        this.setupInfluxClient(context);
        Point setupPoint = Point.measurement("testStartEnd").time(System.currentTimeMillis(), this.writePrecision).addTag("type", "started").addTag(KEY_NODE_NAME, this.nodeName).addTag(KEY_RUN_ID, this.runId).addTag(KEY_TEST_NAME, this.testName).addField("placeholder", "1");
        InfluxDatabaseClient.getInstance(this.influxDBConfig, LOGGER).collectData(setupPoint);
        this.parseSamplers(context);
        this.scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(2);
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.scheduledFuture = this.scheduler.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
        this.recordSubSamples = Boolean.parseBoolean(context.getParameter(KEY_RECORD_SUB_SAMPLES, "false"));
    }

    @Override
    public void teardownTest(BackendListenerContext context) throws Exception {
        LOGGER.info("Shutting down influxDB scheduler...");
        this.timer.cancel();
        this.scheduledFuture.cancel(false);
        this.scheduler.shutdown();
        this.addVirtualUsersMetrics(0, 0, 0, 0, JMeterContextService.getThreadCounts().finishedThreads);
        Point teardownPoint = Point.measurement("testStartEnd").time(System.currentTimeMillis(), this.writePrecision).addTag("type", "finished").addTag(KEY_NODE_NAME, this.nodeName).addTag(KEY_RUN_ID, this.runId).addTag(KEY_TEST_NAME, this.testName).addField("placeholder", "1");
        InfluxDatabaseClient.getInstance(this.influxDBConfig, LOGGER).collectData(teardownPoint);
        try {
            LOGGER.info("influxDB scheduler terminated!");
            if (!this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOGGER.info("Threads didn't finish in 30 seconds!");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Error waiting for end of scheduler " + e);
        }
        InfluxDatabaseClient.getInstance(this.influxDBConfig, LOGGER).close();
        this.samplersToFilter.clear();
        super.teardownTest(context);
    }

    @Override
    public void run() {
        JMeterContextService.ThreadCounts tc = JMeterContextService.getThreadCounts();
        this.addVirtualUsersMetrics(this.getUserMetrics().getMinActiveThreads(), this.getUserMetrics().getMeanActiveThreads(), this.getUserMetrics().getMaxActiveThreads(), tc.startedThreads, tc.finishedThreads);
    }

    private void setupInfluxClient(BackendListenerContext context) {
        this.influxDBConfig = new InfluxDBConfig(context);
        InfluxDatabaseClient.getInstance(this.influxDBConfig, LOGGER).setupInfluxClient();
        this.importDataByTimer(this.influxDBConfig, LOGGER);
    }

    private void parseSamplers(BackendListenerContext context) {
        String samplersList = context.getParameter(KEY_SAMPLERS_LIST, "");
        this.samplersToFilter = new HashSet<String>();
        if (context.getBooleanParameter(KEY_USE_REGEX_FOR_SAMPLER_LIST, false)) {
            this.regexForSamplerList = samplersList;
        } else {
            this.regexForSamplerList = null;
            String[] samplers = samplersList.split(SEPARATOR);
            this.samplersToFilter = new HashSet<String>();
            Collections.addAll(this.samplersToFilter, samplers);
        }
    }

    private void addVirtualUsersMetrics(int minActiveThreads, int meanActiveThreads, int maxActiveThreads, int startedThreads, int finishedThreads) {
        Point virtualUsersMetricsPoint = Point.measurement("virtualUsers").time(System.currentTimeMillis(), this.writePrecision).addField("minActiveThreads", minActiveThreads).addField("maxActiveThreads", maxActiveThreads).addField("meanActiveThreads", meanActiveThreads).addField("startedThreads", startedThreads).addField("finishedThreads", finishedThreads).addTag(KEY_NODE_NAME, this.nodeName).addTag(KEY_TEST_NAME, this.testName).addTag(KEY_RUN_ID, this.runId);
        InfluxDatabaseClient.getInstance(this.influxDBConfig, LOGGER).collectData(virtualUsersMetricsPoint);
    }

    private int getUniqueNumberForTheSamplerThread() {
        return this.randomNumberGenerator.nextInt(1000000);
    }

    public void importDataByTimer(final InfluxDBConfig conf, final Logger logger) {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                LOGGER.debug("Running the timer: " + LocalDate.now());
                InfluxDatabaseClient.getInstance(conf, logger).importData();
            }
        }, 0L, (long)conf.getInfluxdbFlushInterval());
    }
}

