/*
 * Decompiled with CFR 0.152.
 */
package io.github.mderevyankoaqa.influxdb2.visualizer.config;

import com.influxdb.utils.Arguments;
import io.github.mderevyankoaqa.influxdb2.visualizer.config.ArgsValidator;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;

public class InfluxDBConfig {
    public static final String DEFAULT_BUCKET = "jmeter";
    public static final String DEFAULT_INFLUXDB_URL = "http://localhost:8086/";
    public static final int DEFAULT_THRESHOLD_ERROR = 5;
    public static final String DEFAULT_INFLUX_DB_TOKEN = "put token here";
    public static final String DEFAULT_INFLUX_DB_ORG = "performance_testing";
    public static final int DEFAULT_INFLUX_DB_MAX_BATCH_SIZE = 2000;
    public static final int DEFAULT_INFLUX_DB_FLUSH_INTERVAL = 4000;
    public static final int DEFAULT_RESPONSE_BODY_LENGTH = 2000;
    public static final String KEY_INFLUX_DB_URL = "influxDBURL";
    public static final String KEY_INFLUX_DB_BUCKET = "influxDBBucket";
    public static final String KEY_INFLUX_DB_ORG = "influxDBOrganization";
    public static final String KEY_INFLUX_DB_TOKEN = "influxDBToken";
    public static final String KEY_INFLUX_DB_MAX_BATCH_SIZE = "influxDBMaxBatchSize";
    public static final String KEY_INFLUX_DB_FLUSH_INTERVAL = "influxDBFlushInterval";
    public static final String KEY_INFLUX_DB_THRESHOLD_ERROR = "influxDBThresholdError";
    public static final String KEY_RESPONSE_BODY_LENGTH = "responseBodyLength";
    private String influxDBURL;
    private String influxToken;
    private String influxOrganization;
    private String influxBucket;
    private int influxdbBatchSize;
    private int influxdbFlushInterval;
    private int influxdbThresholdError;
    private int responseBodyLength;

    public InfluxDBConfig(BackendListenerContext context) {
        String influxDBURL = context.getParameter(KEY_INFLUX_DB_URL);
        Arguments.checkNonEmpty(influxDBURL, KEY_INFLUX_DB_URL);
        String[] influxHTTPScheme = influxDBURL.split("://", 2);
        ArgsValidator.checkHTTPScheme(influxHTTPScheme[0]);
        this.setInfluxDBURL(influxDBURL);
        String influxToken = context.getParameter(KEY_INFLUX_DB_TOKEN);
        Arguments.checkNonEmpty(influxToken, KEY_INFLUX_DB_TOKEN);
        this.setInfluxToken(influxToken);
        String influxOrg = context.getParameter(KEY_INFLUX_DB_ORG);
        Arguments.checkNonEmpty(influxOrg, KEY_INFLUX_DB_ORG);
        this.setInfluxOrganization(influxOrg);
        String influxBucket = context.getParameter(KEY_INFLUX_DB_BUCKET);
        Arguments.checkNonEmpty(influxBucket, KEY_INFLUX_DB_BUCKET);
        this.setInfluxBucket(influxBucket);
        int influxdbBatchSize = context.getIntParameter(KEY_INFLUX_DB_MAX_BATCH_SIZE);
        Arguments.checkNotNegativeNumber(influxdbBatchSize, KEY_INFLUX_DB_MAX_BATCH_SIZE);
        this.setInfluxdbBatchSize(influxdbBatchSize);
        int influxdbFlushInterval = context.getIntParameter(KEY_INFLUX_DB_FLUSH_INTERVAL);
        Arguments.checkNotNegativeNumber(influxdbFlushInterval, KEY_INFLUX_DB_FLUSH_INTERVAL);
        this.setInfluxdbFlushInterval(influxdbFlushInterval);
        int influxdbThresholdError = context.getIntParameter(KEY_INFLUX_DB_THRESHOLD_ERROR, 5);
        Arguments.checkNotNegativeNumber(influxdbThresholdError, KEY_INFLUX_DB_THRESHOLD_ERROR);
        this.setInfluxdbThresholdError(influxdbThresholdError);
        int responseBodyLength = context.getIntParameter(KEY_RESPONSE_BODY_LENGTH);
        Arguments.checkNotNegativeNumber(influxdbFlushInterval, KEY_RESPONSE_BODY_LENGTH);
        this.setResponseBodyLength(responseBodyLength);
    }

    public String getInfluxDBURL() {
        return this.influxDBURL;
    }

    public void setInfluxDBURL(String influxDBURL) {
        this.influxDBURL = influxDBURL;
    }

    public String getInfluxBucket() {
        return this.influxBucket;
    }

    public void setInfluxBucket(String influxBucket) {
        this.influxBucket = influxBucket;
    }

    public String getInfluxOrganization() {
        return this.influxOrganization;
    }

    public void setInfluxOrganization(String influxOrganization) {
        this.influxOrganization = influxOrganization;
    }

    public String getInfluxToken() {
        return this.influxToken;
    }

    public void setInfluxToken(String influxToken) {
        this.influxToken = influxToken;
    }

    public void setInfluxdbBatchSize(int influxdbBatchSize) {
        this.influxdbBatchSize = influxdbBatchSize;
    }

    public int getInfluxdbBatchSize() {
        return this.influxdbBatchSize;
    }

    public int getInfluxdbFlushInterval() {
        return this.influxdbFlushInterval;
    }

    public void setInfluxdbFlushInterval(int influxdbFlushInterval) {
        this.influxdbFlushInterval = influxdbFlushInterval;
    }

    public void setInfluxdbThresholdError(int influxdbThresholdError) {
        this.influxdbThresholdError = influxdbThresholdError;
    }

    public int getInfluxdbThresholdError() {
        return this.influxdbThresholdError;
    }

    public int getResponseBodyLength() {
        return this.responseBodyLength;
    }

    public void setResponseBodyLength(int responseBodyLength) {
        this.responseBodyLength = responseBodyLength;
    }
}

