/*
 * Decompiled with CFR 0.152.
 */
package io.github.mderevyankoaqa.influxdb2.visualizer.influxdb.client;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.WriteApiBlocking;
import com.influxdb.client.write.Point;
import io.github.mderevyankoaqa.influxdb2.visualizer.config.InfluxDBConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class InfluxDatabaseClient {
    private final Logger LOGGER;
    private final InfluxDBConfig influxDBConfig;
    private final List<Point> points = Collections.synchronizedList(new ArrayList());
    private InfluxDBClient influxDB;
    private WriteApiBlocking writeApi;
    private final List<Integer> errorsAmount = Collections.synchronizedList(new ArrayList());
    private static volatile InfluxDatabaseClient instance;

    private InfluxDatabaseClient(InfluxDBConfig config, Logger logger) {
        this.influxDBConfig = config;
        this.LOGGER = logger;
        this.LOGGER.info("New instance of InfluxDatabaseClient has been created!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InfluxDatabaseClient getInstance(InfluxDBConfig config, Logger logger) {
        InfluxDatabaseClient result = instance;
        if (result != null) {
            return result;
        }
        Class<InfluxDatabaseClient> clazz = InfluxDatabaseClient.class;
        synchronized (InfluxDatabaseClient.class) {
            if (instance == null) {
                instance = new InfluxDatabaseClient(config, logger);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void collectData(Point point) {
        this.LOGGER.debug("Sending to write");
        this.points.add(point);
        this.checkBatchSize();
    }

    public synchronized void close() {
        this.LOGGER.info("The final step ---> importing before closing.");
        this.importData();
        this.influxDB.close();
        this.points.clear();
        if (instance != null) {
            instance = null;
            this.LOGGER.info("Instance of InfluxDatabaseClient has been refreshed!");
        }
    }

    public synchronized void importData() {
        if (this.errorsAmount.size() >= this.influxDBConfig.getInfluxdbThresholdError()) {
            this.points.clear();
            this.LOGGER.warn("Importing of the results to Influx DB is skipping since " + this.influxDBConfig.getInfluxdbThresholdError() + " errors, has occurred!");
        }
        if (this.points.size() != 0 && this.errorsAmount.size() <= this.influxDBConfig.getInfluxdbThresholdError()) {
            try {
                long start = System.currentTimeMillis();
                this.writeApi.writePoints(this.points);
                long end = System.currentTimeMillis();
                if (this.errorsAmount.size() != 0) {
                    this.errorsAmount.clear();
                    this.LOGGER.warn("Counter of the errors refreshed since import was done successfully.");
                }
                this.LOGGER.info("Data has been imported successfully, batch with size is --> " + this.points.size() + ", elapsed time is --> " + (end - start) + " ms");
                this.points.clear();
                this.LOGGER.debug("Points have been cleaned");
            }
            catch (Exception e) {
                this.LOGGER.error("Error has occurred, batch with size " + this.points.size() + " was not imported, see the details --> " + e.getMessage());
                this.errorsAmount.add(1);
            }
        }
    }

    public synchronized void setupInfluxClient() {
        this.LOGGER.info("InfluxDBClientFactory is going to use the following properties:");
        this.LOGGER.info("URL --> " + this.influxDBConfig.getInfluxDBURL());
        this.LOGGER.info("Token --> " + this.influxDBConfig.getInfluxToken());
        this.LOGGER.info("Organization --> " + this.influxDBConfig.getInfluxOrganization());
        this.LOGGER.info("Bucket --> " + this.influxDBConfig.getInfluxBucket());
        try {
            this.influxDB = InfluxDBClientFactory.create(this.influxDBConfig.getInfluxDBURL(), this.influxDBConfig.getInfluxToken().toCharArray(), this.influxDBConfig.getInfluxOrganization(), this.influxDBConfig.getInfluxBucket());
            this.influxDB.enableGzip();
            this.writeApi = this.influxDB.getWriteApiBlocking();
        }
        catch (Exception e) {
            this.LOGGER.error("Failed to create client", e);
        }
    }

    private synchronized void checkBatchSize() {
        if (this.points.size() >= this.influxDBConfig.getInfluxdbBatchSize()) {
            this.LOGGER.info("Batch size protection has occurred.");
            this.importData();
        }
    }
}

