/*
 * Decompiled with CFR 0.152.
 */
package io.github.mderevyankoaqa.influxdb2.visualizer.result;

import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import io.github.mderevyankoaqa.influxdb2.visualizer.influxdb.client.InfluxDatabaseUtility;
import io.github.mderevyankoaqa.influxdb2.visualizer.result.SampleResultPointContext;

public class SampleResultPointProvider {
    private final SampleResultPointContext sampleResultContext;
    private static final String NO_DATA = "noData";

    public SampleResultPointProvider(SampleResultPointContext sampleResultContext) {
        this.sampleResultContext = sampleResultContext;
    }

    public Point getPoint() {
        Point point = this.getDefaultPoint();
        if (this.sampleResultContext.getSampleResult().getErrorCount() == 0) {
            point.addTag("result", "pass");
        } else {
            point.addTag("result", "fail");
        }
        return point;
    }

    private String getErrorBodyToBeSaved(boolean isToBeSaved, boolean isSuccessful) {
        String errorResponseBody = isToBeSaved && isSuccessful ? this.getErrorBody() : NO_DATA;
        return errorResponseBody;
    }

    private String getAssertionFailure() {
        String assertionMsg = this.sampleResultContext.getSampleResult().getFirstAssertionFailureMessage();
        if (assertionMsg == null) {
            assertionMsg = NO_DATA;
        }
        return assertionMsg;
    }

    private String getErrorBody() {
        String errorBody = this.sampleResultContext.getSampleResult().getResponseDataAsString();
        if (errorBody != null && !errorBody.isEmpty()) {
            return InfluxDatabaseUtility.getSubstring(InfluxDatabaseUtility.getEscapedString(errorBody), this.sampleResultContext.getResponseBodyLength());
        }
        return NO_DATA;
    }

    private Point getDefaultPoint() {
        return Point.measurement("requestsRaw").time(this.sampleResultContext.getTimeToSet(), WritePrecision.NS).addTag("requestName", this.sampleResultContext.getSampleResult().getSampleLabel()).addTag("runId", this.sampleResultContext.getRunId()).addTag("testName", this.sampleResultContext.getTestName()).addTag("nodeName", this.sampleResultContext.getNodeName()).addTag("responseCode", this.sampleResultContext.getSampleResult().getResponseCode()).addTag("errorMessage", this.getAssertionFailure()).addTag("samplerType", this.sampleResultContext.getSamplerType()).addTag("errorResponseBody", this.getErrorBodyToBeSaved(this.sampleResultContext.isErrorBodyToBeSaved(), !this.sampleResultContext.getSampleResult().isSuccessful())).addField("errorCount", this.sampleResultContext.getSampleResult().getErrorCount()).addField("count", this.sampleResultContext.getSampleResult().getSampleCount()).addField("receivedBytes", this.sampleResultContext.getSampleResult().getBytesAsLong()).addField("sentBytes", this.sampleResultContext.getSampleResult().getSentBytes()).addField("responseTime", this.sampleResultContext.getSampleResult().getTime()).addField("latency", this.sampleResultContext.getSampleResult().getLatency()).addField("connectTime", this.sampleResultContext.getSampleResult().getConnectTime()).addField("processingTime", this.sampleResultContext.getSampleResult().getLatency() - this.sampleResultContext.getSampleResult().getConnectTime());
    }
}

