/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.fuseable.HasUpstreamObservableSource;
import io.reactivex.rxjava3.internal.operators.observable.ObserverResourceWrapper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.observables.ConnectableObservable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.Timed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableReplay<T>
extends ConnectableObservable<T>
implements HasUpstreamObservableSource<T> {
    final ObservableSource<T> source;
    final AtomicReference<ReplayObserver<T>> current;
    final BufferSupplier<T> bufferFactory;
    final ObservableSource<T> onSubscribe;
    static final BufferSupplier DEFAULT_UNBOUNDED_FACTORY = new UnBoundedFactory();

    public static <U, R> Observable<R> multicastSelector(Supplier<? extends ConnectableObservable<U>> connectableFactory, Function<? super Observable<U>, ? extends ObservableSource<R>> selector) {
        return RxJavaPlugins.onAssembly(new MulticastReplay(connectableFactory, selector));
    }

    public static <T> ConnectableObservable<T> createFrom(ObservableSource<? extends T> source2) {
        return ObservableReplay.create(source2, DEFAULT_UNBOUNDED_FACTORY);
    }

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source2, int bufferSize, boolean eagerTruncate) {
        if (bufferSize == Integer.MAX_VALUE) {
            return ObservableReplay.createFrom(source2);
        }
        return ObservableReplay.create(source2, new ReplayBufferSupplier(bufferSize, eagerTruncate));
    }

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source2, long maxAge, TimeUnit unit, Scheduler scheduler, boolean eagerTruncate) {
        return ObservableReplay.create(source2, maxAge, unit, scheduler, Integer.MAX_VALUE, eagerTruncate);
    }

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source2, long maxAge, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean eagerTruncate) {
        return ObservableReplay.create(source2, new ScheduledReplaySupplier(bufferSize, maxAge, unit, scheduler, eagerTruncate));
    }

    static <T> ConnectableObservable<T> create(ObservableSource<T> source2, BufferSupplier<T> bufferFactory) {
        AtomicReference curr = new AtomicReference();
        ReplaySource onSubscribe = new ReplaySource(curr, bufferFactory);
        return RxJavaPlugins.onAssembly(new ObservableReplay(onSubscribe, source2, curr, bufferFactory));
    }

    private ObservableReplay(ObservableSource<T> onSubscribe, ObservableSource<T> source2, AtomicReference<ReplayObserver<T>> current, BufferSupplier<T> bufferFactory) {
        this.onSubscribe = onSubscribe;
        this.source = source2;
        this.current = current;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public ObservableSource<T> source() {
        return this.source;
    }

    @Override
    public void reset() {
        ReplayObserver<T> conn = this.current.get();
        if (conn != null && conn.isDisposed()) {
            this.current.compareAndSet(conn, null);
        }
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.onSubscribe.subscribe(observer);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        ReplayObserver<T> ps;
        while ((ps = this.current.get()) == null || ps.isDisposed()) {
            ReplayBuffer<T> buf = this.bufferFactory.call();
            ReplayObserver<T> u = new ReplayObserver<T>(buf, this.current);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            if (doConnect) {
                ps.shouldConnect.compareAndSet(true, false);
            }
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (doConnect) {
            this.source.subscribe(ps);
        }
    }

    static final class MulticastReplay<R, U>
    extends Observable<R> {
        private final Supplier<? extends ConnectableObservable<U>> connectableFactory;
        private final Function<? super Observable<U>, ? extends ObservableSource<R>> selector;

        MulticastReplay(Supplier<? extends ConnectableObservable<U>> connectableFactory, Function<? super Observable<U>, ? extends ObservableSource<R>> selector) {
            this.connectableFactory = connectableFactory;
            this.selector = selector;
        }

        @Override
        protected void subscribeActual(Observer<? super R> child) {
            ObservableSource<R> observable;
            ConnectableObservable<U> co;
            try {
                co = Objects.requireNonNull(this.connectableFactory.get(), "The connectableFactory returned a null ConnectableObservable");
                observable = Objects.requireNonNull(this.selector.apply(co), "The selector returned a null ObservableSource");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                EmptyDisposable.error(e, child);
                return;
            }
            ObserverResourceWrapper<? super R> srw = new ObserverResourceWrapper<R>(child);
            observable.subscribe(srw);
            co.connect(new DisposeConsumer<R>(srw));
        }
    }

    static final class ReplaySource<T>
    implements ObservableSource<T> {
        private final AtomicReference<ReplayObserver<T>> curr;
        private final BufferSupplier<T> bufferFactory;

        ReplaySource(AtomicReference<ReplayObserver<T>> curr, BufferSupplier<T> bufferFactory) {
            this.curr = curr;
            this.bufferFactory = bufferFactory;
        }

        @Override
        public void subscribe(Observer<? super T> child) {
            ReplayObserver<Object> r;
            while ((r = this.curr.get()) == null) {
                ReplayBuffer<T> buf = this.bufferFactory.call();
                ReplayObserver<T> u = new ReplayObserver<T>(buf, this.curr);
                if (!this.curr.compareAndSet(null, u)) continue;
                r = u;
                break;
            }
            InnerDisposable<T> inner = new InnerDisposable<T>(r, child);
            child.onSubscribe(inner);
            r.add(inner);
            if (inner.isDisposed()) {
                r.remove(inner);
                return;
            }
            r.buffer.replay(inner);
        }
    }

    static final class ScheduledReplaySupplier<T>
    implements BufferSupplier<T> {
        private final int bufferSize;
        private final long maxAge;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        final boolean eagerTruncate;

        ScheduledReplaySupplier(int bufferSize, long maxAge, TimeUnit unit, Scheduler scheduler, boolean eagerTruncate) {
            this.bufferSize = bufferSize;
            this.maxAge = maxAge;
            this.unit = unit;
            this.scheduler = scheduler;
            this.eagerTruncate = eagerTruncate;
        }

        @Override
        public ReplayBuffer<T> call() {
            return new SizeAndTimeBoundReplayBuffer(this.bufferSize, this.maxAge, this.unit, this.scheduler, this.eagerTruncate);
        }
    }

    static final class ReplayBufferSupplier<T>
    implements BufferSupplier<T> {
        final int bufferSize;
        final boolean eagerTruncate;

        ReplayBufferSupplier(int bufferSize, boolean eagerTruncate) {
            this.bufferSize = bufferSize;
            this.eagerTruncate = eagerTruncate;
        }

        @Override
        public ReplayBuffer<T> call() {
            return new SizeBoundReplayBuffer(this.bufferSize, this.eagerTruncate);
        }
    }

    static final class DisposeConsumer<R>
    implements Consumer<Disposable> {
        private final ObserverResourceWrapper<R> srw;

        DisposeConsumer(ObserverResourceWrapper<R> srw) {
            this.srw = srw;
        }

        @Override
        public void accept(Disposable r) {
            this.srw.setResource(r);
        }
    }

    static final class UnBoundedFactory
    implements BufferSupplier<Object> {
        UnBoundedFactory() {
        }

        @Override
        public ReplayBuffer<Object> call() {
            return new UnboundedReplayBuffer<Object>(16);
        }
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = 3457957419649567404L;
        final Scheduler scheduler;
        final long maxAge;
        final TimeUnit unit;
        final int limit;

        SizeAndTimeBoundReplayBuffer(int limit, long maxAge, TimeUnit unit, Scheduler scheduler, boolean eagerTruncate) {
            super(eagerTruncate);
            this.scheduler = scheduler;
            this.limit = limit;
            this.maxAge = maxAge;
            this.unit = unit;
        }

        @Override
        Object enterTransform(Object value) {
            return new Timed<Object>(value, this.scheduler.now(this.unit), this.unit);
        }

        @Override
        Object leaveTransform(Object value) {
            return ((Timed)value).value();
        }

        @Override
        void truncate() {
            long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            Node next = (Node)prev.get();
            int e = 0;
            while (this.size > 1) {
                if (this.size > this.limit) {
                    ++e;
                    --this.size;
                    prev = next;
                    next = (Node)next.get();
                    continue;
                }
                Timed v = (Timed)next.value;
                if (v.time() > timeLimit) break;
                ++e;
                --this.size;
                prev = next;
                next = (Node)next.get();
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        void truncateFinal() {
            Timed v;
            long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            Node next = (Node)prev.get();
            int e = 0;
            while (this.size > 1 && (v = (Timed)next.value).time() <= timeLimit) {
                ++e;
                --this.size;
                prev = next;
                next = (Node)next.get();
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        Node getHead() {
            Timed v;
            long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            for (Node next = (Node)prev.get(); next != null && !NotificationLite.isComplete((v = (Timed)next.value).value()) && !NotificationLite.isError(v.value()) && v.time() <= timeLimit; next = (Node)next.get()) {
                prev = next;
            }
            return prev;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = -5898283885385201806L;
        final int limit;

        SizeBoundReplayBuffer(int limit, boolean eagerTruncate) {
            super(eagerTruncate);
            this.limit = limit;
        }

        @Override
        void truncate() {
            if (this.size > this.limit) {
                this.removeFirst();
            }
        }
    }

    static abstract class BoundedReplayBuffer<T>
    extends AtomicReference<Node>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 2346567790059478686L;
        Node tail;
        int size;
        final boolean eagerTruncate;

        BoundedReplayBuffer(boolean eagerTruncate) {
            Node n;
            this.eagerTruncate = eagerTruncate;
            this.tail = n = new Node((Object)null);
            this.set(n);
        }

        final void addLast(Node n) {
            this.tail.set(n);
            this.tail = n;
            ++this.size;
        }

        final void removeFirst() {
            Node head = (Node)this.get();
            Node next = (Node)head.get();
            --this.size;
            this.setFirst(next);
        }

        final void trimHead() {
            Node head = (Node)this.get();
            if (head.value != null) {
                Node n = new Node((Object)null);
                n.lazySet(head.get());
                this.set(n);
            }
        }

        final void removeSome(int n) {
            Node head = (Node)this.get();
            while (n > 0) {
                head = (Node)head.get();
                --n;
                --this.size;
            }
            this.setFirst(head);
            head = (Node)this.get();
            if (head.get() == null) {
                this.tail = head;
            }
        }

        final void setFirst(Node n) {
            if (this.eagerTruncate) {
                Node m = new Node((Object)null);
                m.lazySet(n.get());
                n = m;
            }
            this.set(n);
        }

        @Override
        public final void next(T value) {
            Object o = this.enterTransform(NotificationLite.next(value));
            Node n = new Node(o);
            this.addLast(n);
            this.truncate();
        }

        @Override
        public final void error(Throwable e) {
            Object o = this.enterTransform(NotificationLite.error(e));
            Node n = new Node(o);
            this.addLast(n);
            this.truncateFinal();
        }

        @Override
        public final void complete() {
            Object o = this.enterTransform(NotificationLite.complete());
            Node n = new Node(o);
            this.addLast(n);
            this.truncateFinal();
        }

        @Override
        public final void replay(InnerDisposable<T> output) {
            if (output.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            do {
                Node node;
                if ((node = (Node)output.index()) == null) {
                    node = this.getHead();
                    output.index = node;
                }
                while (true) {
                    if (output.isDisposed()) {
                        output.index = null;
                        return;
                    }
                    Node v = (Node)node.get();
                    if (v == null) break;
                    Object o = this.leaveTransform(v.value);
                    if (NotificationLite.accept(o, output.child)) {
                        output.index = null;
                        return;
                    }
                    node = v;
                }
                output.index = node;
            } while ((missed = output.addAndGet(-missed)) != 0);
        }

        Object enterTransform(Object value) {
            return value;
        }

        Object leaveTransform(Object value) {
            return value;
        }

        abstract void truncate();

        void truncateFinal() {
            this.trimHead();
        }

        final void collect(Collection<? super T> output) {
            Object o;
            Object v;
            Node next;
            Node n = this.getHead();
            while ((next = (Node)n.get()) != null && !NotificationLite.isComplete(v = this.leaveTransform(o = next.value)) && !NotificationLite.isError(v)) {
                output.add(NotificationLite.getValue(v));
                n = next;
            }
        }

        boolean hasError() {
            return this.tail.value != null && NotificationLite.isError(this.leaveTransform(this.tail.value));
        }

        boolean hasCompleted() {
            return this.tail.value != null && NotificationLite.isComplete(this.leaveTransform(this.tail.value));
        }

        Node getHead() {
            return (Node)this.get();
        }
    }

    static final class Node
    extends AtomicReference<Node> {
        private static final long serialVersionUID = 245354315435971818L;
        final Object value;

        Node(Object value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends ArrayList<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 7063189396499112664L;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            super(capacityHint);
        }

        @Override
        public void next(T value) {
            this.add(NotificationLite.next(value));
            ++this.size;
        }

        @Override
        public void error(Throwable e) {
            this.add(NotificationLite.error(e));
            ++this.size;
        }

        @Override
        public void complete() {
            this.add(NotificationLite.complete());
            ++this.size;
        }

        @Override
        public void replay(InnerDisposable<T> output) {
            if (output.getAndIncrement() != 0) {
                return;
            }
            Observer child = output.child;
            int missed = 1;
            do {
                int destinationIndex;
                if (output.isDisposed()) {
                    return;
                }
                int sourceIndex = this.size;
                Integer destinationIndexObject = (Integer)output.index();
                int n = destinationIndex = destinationIndexObject != null ? destinationIndexObject : 0;
                while (destinationIndex < sourceIndex) {
                    Object o = this.get(destinationIndex);
                    if (NotificationLite.accept(o, child)) {
                        return;
                    }
                    if (output.isDisposed()) {
                        return;
                    }
                    ++destinationIndex;
                }
                output.index = destinationIndex;
            } while ((missed = output.addAndGet(-missed)) != 0);
        }
    }

    static interface ReplayBuffer<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(InnerDisposable<T> var1);
    }

    static final class InnerDisposable<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 2728361546769921047L;
        final ReplayObserver<T> parent;
        final Observer<? super T> child;
        Object index;
        volatile boolean cancelled;

        InnerDisposable(ReplayObserver<T> parent, Observer<? super T> child) {
            this.parent = parent;
            this.child = child;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.remove(this);
                this.index = null;
            }
        }

        <U> U index() {
            return (U)this.index;
        }
    }

    static final class ReplayObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -533785617179540163L;
        final ReplayBuffer<T> buffer;
        boolean done;
        static final InnerDisposable[] EMPTY = new InnerDisposable[0];
        static final InnerDisposable[] TERMINATED = new InnerDisposable[0];
        final AtomicReference<InnerDisposable[]> observers;
        final AtomicBoolean shouldConnect;
        final AtomicReference<ReplayObserver<T>> current;

        ReplayObserver(ReplayBuffer<T> buffer, AtomicReference<ReplayObserver<T>> current) {
            this.buffer = buffer;
            this.current = current;
            this.observers = new AtomicReference<InnerDisposable[]>(EMPTY);
            this.shouldConnect = new AtomicBoolean();
        }

        @Override
        public boolean isDisposed() {
            return this.observers.get() == TERMINATED;
        }

        @Override
        public void dispose() {
            this.observers.set(TERMINATED);
            this.current.compareAndSet(this, null);
            DisposableHelper.dispose(this);
        }

        boolean add(InnerDisposable<T> producer) {
            InnerDisposable[] u;
            InnerDisposable[] c;
            do {
                if ((c = this.observers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerDisposable[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.observers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerDisposable<T> producer) {
            InnerDisposable[] u;
            InnerDisposable[] c;
            do {
                int len;
                if ((len = (c = this.observers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                    continue;
                }
                u = new InnerDisposable[len - 1];
                System.arraycopy(c, 0, u, 0, j);
                System.arraycopy(c, j + 1, u, j, len - j - 1);
            } while (!this.observers.compareAndSet(c, u));
        }

        @Override
        public void onSubscribe(Disposable p) {
            if (DisposableHelper.setOnce(this, p)) {
                this.replay();
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.done) {
                this.buffer.next(t);
                this.replay();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.done) {
                this.done = true;
                this.buffer.error(e);
                this.replayFinal();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.buffer.complete();
                this.replayFinal();
            }
        }

        void replay() {
            InnerDisposable[] a;
            for (InnerDisposable rp : a = this.observers.get()) {
                this.buffer.replay(rp);
            }
        }

        void replayFinal() {
            InnerDisposable[] a;
            for (InnerDisposable rp : a = this.observers.getAndSet(TERMINATED)) {
                this.buffer.replay(rp);
            }
        }
    }

    static interface BufferSupplier<T> {
        public ReplayBuffer<T> call();
    }
}

