/*
 * Decompiled with CFR 0.152.
 */
package jodd.net;

import java.io.ByteArrayOutputStream;
import jodd.core.JoddCore;
import jodd.util.StringUtil;

public class URLDecoder {
    public static String decode(String url) {
        return URLDecoder.decode(url, JoddCore.encoding, false);
    }

    public static String decode(String source2, String encoding) {
        return URLDecoder.decode(source2, encoding, false);
    }

    public static String decodeQuery(String source2) {
        return URLDecoder.decode(source2, JoddCore.encoding, true);
    }

    public static String decodeQuery(String source2, String encoding) {
        return URLDecoder.decode(source2, encoding, true);
    }

    private static String decode(String source2, String encoding, boolean decodePlus) {
        int length = source2.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        block4: for (int i = 0; i < length; ++i) {
            int ch = source2.charAt(i);
            switch (ch) {
                case 37: {
                    if (i + 2 < length) {
                        char hex1 = source2.charAt(i + 1);
                        char hex2 = source2.charAt(i + 2);
                        int u = Character.digit(hex1, 16);
                        int l = Character.digit(hex2, 16);
                        if (u == -1 || l == -1) {
                            throw new IllegalArgumentException("Invalid sequence: " + source2.substring(i));
                        }
                        bos.write((char)((u << 4) + l));
                        i += 2;
                        changed = true;
                        continue block4;
                    }
                    throw new IllegalArgumentException("Invalid sequence: " + source2.substring(i));
                }
                case 43: {
                    if (decodePlus) {
                        ch = 32;
                        changed = true;
                    }
                }
                default: {
                    bos.write(ch);
                }
            }
        }
        return changed ? StringUtil.newString(bos.toByteArray(), encoding) : source2;
    }
}

