/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import jodd.Jodd;
import jodd.bridge.ClassPathURLs;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;
import jodd.util.cl.ClassLoaderStrategy;

public class ClassLoaderUtil {
    private static final String[] MANIFESTS = new String[]{"Manifest.mf", "manifest.mf", "MANIFEST.MF"};

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = ClassLoaderUtil.getContextClassLoader();
        if (cl == null) {
            Class callerClass = ClassUtil.getCallerClass(2);
            cl = callerClass.getClassLoader();
        }
        return cl;
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Manifest getClasspathItemManifest(File classpathItem) {
        Manifest manifest;
        block10: {
            block11: {
                manifest = null;
                if (!classpathItem.isFile()) break block11;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(classpathItem);
                    JarFile jar = new JarFile(classpathItem);
                    manifest = jar.getManifest();
                }
                catch (IOException jar) {
                    StreamUtil.close(fis);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(fis);
                    throw throwable;
                }
                StreamUtil.close(fis);
                break block10;
            }
            File metaDir = new File(classpathItem, "META-INF");
            File manifestFile = null;
            if (metaDir.isDirectory()) {
                for (String m : MANIFESTS) {
                    File mFile = new File(metaDir, m);
                    if (!mFile.isFile()) continue;
                    manifestFile = mFile;
                    break;
                }
            }
            if (manifestFile != null) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(manifestFile);
                    manifest = new Manifest(fis);
                }
                catch (IOException iOException) {
                    StreamUtil.close(fis);
                    catch (Throwable throwable) {
                        StreamUtil.close(fis);
                        throw throwable;
                    }
                }
                StreamUtil.close(fis);
            }
        }
        return manifest;
    }

    public static String getClasspathItemBaseDir(File classpathItem) {
        String base = classpathItem.isFile() ? classpathItem.getParent() : classpathItem.toString();
        return base;
    }

    public static File[] getDefaultClasspath() {
        return ClassLoaderUtil.getDefaultClasspath(ClassLoaderUtil.getDefaultClassLoader());
    }

    public static File[] getDefaultClasspath(ClassLoader classLoader) {
        TreeSet<File> classpaths = new TreeSet<File>();
        while (classLoader != null) {
            URL[] urls2 = ClassPathURLs.of(classLoader, null);
            if (urls2 != null) {
                for (URL u : urls2) {
                    File f = FileUtil.toContainerFile(u);
                    if (f == null || !f.exists()) continue;
                    try {
                        f = f.getCanonicalFile();
                        boolean newElement = classpaths.add(f);
                        if (!newElement) continue;
                        ClassLoaderUtil.addInnerClasspathItems(classpaths, f);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            classLoader = classLoader.getParent();
        }
        File[] result = new File[classpaths.size()];
        return classpaths.toArray(result);
    }

    private static void addInnerClasspathItems(Set<File> classpaths, File item) {
        String[] tokens;
        Manifest manifest = ClassLoaderUtil.getClasspathItemManifest(item);
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return;
        }
        String s = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (s == null) {
            return;
        }
        String base = ClassLoaderUtil.getClasspathItemBaseDir(item);
        for (String t : tokens = StringUtil.splitc(s, ' ')) {
            File file;
            try {
                file = new File(base, t);
                file = file.getCanonicalFile();
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception ignore) {
                file = null;
            }
            if (file == null) {
                try {
                    file = new File(t);
                    file = file.getCanonicalFile();
                    if (!file.exists()) {
                        file = null;
                    }
                }
                catch (Exception ignore) {
                    file = null;
                }
            }
            if (file == null) {
                try {
                    URL url = new URL(t);
                    file = new File(url.getFile());
                    file = file.getCanonicalFile();
                    if (!file.exists()) {
                        file = null;
                    }
                }
                catch (Exception ignore) {
                    file = null;
                }
            }
            if (file == null || !file.exists()) continue;
            classpaths.add(file);
        }
    }

    public static URL getResourceUrl(String resourceName) {
        return ClassLoaderUtil.getResourceUrl(resourceName, null);
    }

    public static URL getResourceUrl(String resourceName, ClassLoader classLoader) {
        URL resourceUrl;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (classLoader != null && (resourceUrl = classLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader && (resourceUrl = currentThreadClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        Class callerClass = ClassUtil.getCallerClass(2);
        ClassLoader callerClassLoader = callerClass.getClassLoader();
        if (callerClassLoader != classLoader && callerClassLoader != currentThreadClassLoader && (resourceUrl = callerClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(resourceName, null);
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass) throws IOException {
        URL url = ClassLoaderUtil.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass, boolean useCache) throws IOException {
        URL url = ClassLoaderUtil.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(useCache);
            return urlConnection.getInputStream();
        }
        return null;
    }

    public static InputStream getClassAsStream(Class clazz) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassUtil.convertClassNameToFileName(clazz), clazz.getClassLoader());
    }

    public static InputStream getClassAsStream(String className) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassUtil.convertClassNameToFileName(className));
    }

    public static InputStream getClassAsStream(String className, ClassLoader classLoader) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassUtil.convertClassNameToFileName(className), classLoader);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderStrategy.get().loadClass(className, null);
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassLoaderStrategy.get().loadClass(className, classLoader);
    }

    public static String classLocation(Class clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public static String joddLocation() {
        return ClassLoaderUtil.classLocation(Jodd.class);
    }
}

