/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.avalon;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;
import org.apache.commons.cli.avalon.ParserControl;
import org.apache.commons.cli.avalon.Token;

public final class CLArgsParser {
    private static final int INVALID = Integer.MAX_VALUE;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_REQUIRE_2ARGS = 1;
    private static final int STATE_REQUIRE_ARG = 2;
    private static final int STATE_OPTIONAL_ARG = 3;
    private static final int STATE_NO_OPTIONS = 4;
    private static final int STATE_OPTION_MODE = 5;
    private static final int TOKEN_SEPARATOR = 0;
    private static final int TOKEN_STRING = 1;
    private static final char[] ARG_SEPARATORS = new char[]{'\u0000', '='};
    private static final char[] NULL_SEPARATORS = new char[]{'\u0000'};
    private final CLOptionDescriptor[] optionDescriptors;
    private final List<CLOption> options = new ArrayList<CLOption>();
    private Map<Object, CLOption> optionIndex;
    private final ParserControl control;
    private String errorMessage;
    private String[] unparsedArgs = new String[0];
    private char ch;
    private final String[] args;
    private boolean isLong;
    private int argIndex;
    private int stringIndex;
    private int stringLength;
    private int lastChar = Integer.MAX_VALUE;
    private int lastOptionId;
    private CLOption option;
    private int state = 0;
    private char tokesep;

    public final String[] getUnparsedArgs() {
        return this.unparsedArgs;
    }

    public final List<CLOption> getArguments() {
        return this.options;
    }

    public final CLOption getArgumentById(int id) {
        return this.optionIndex.get(id);
    }

    public final CLOption getArgumentByName(String name) {
        return this.optionIndex.get(name);
    }

    private CLOptionDescriptor getDescriptorFor(int id) {
        for (CLOptionDescriptor optionDescriptor : this.optionDescriptors) {
            if (optionDescriptor.getId() != id) continue;
            return optionDescriptor;
        }
        return null;
    }

    private CLOptionDescriptor getDescriptorFor(String name) {
        for (CLOptionDescriptor optionDescriptor : this.optionDescriptors) {
            if (!optionDescriptor.getName().equals(name)) continue;
            return optionDescriptor;
        }
        return null;
    }

    public final String getErrorString() {
        return this.errorMessage;
    }

    private static int getStateFor(CLOptionDescriptor descriptor) {
        int flags = descriptor.getFlags();
        if ((flags & 0x10) == 16) {
            return 1;
        }
        if ((flags & 2) == 2) {
            return 2;
        }
        if ((flags & 4) == 4) {
            return 3;
        }
        return 0;
    }

    public CLArgsParser(String[] args2, CLOptionDescriptor[] optionDescriptors, ParserControl control) {
        this.optionDescriptors = optionDescriptors;
        this.control = control;
        this.args = args2;
        try {
            this.parse();
            this.checkIncompatibilities(this.options);
            this.buildOptionIndex();
        }
        catch (ParseException pe) {
            this.errorMessage = pe.getMessage();
        }
    }

    private void checkIncompatibilities(List<CLOption> arguments) throws ParseException {
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            CLOption option = arguments.get(i);
            int id = option.getDescriptor().getId();
            CLOptionDescriptor descriptor = this.getDescriptorFor(id);
            if (null == descriptor) continue;
            int[] incompatible = descriptor.getIncompatible();
            this.checkIncompatible(arguments, incompatible, i);
        }
    }

    private void checkIncompatible(List<CLOption> arguments, int[] incompatible, int original) throws ParseException {
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            if (original == i) continue;
            CLOption option = arguments.get(i);
            int id = option.getDescriptor().getId();
            for (int anIncompatible : incompatible) {
                if (id != anIncompatible) continue;
                CLOption originalOption = arguments.get(original);
                int originalId = originalOption.getDescriptor().getId();
                String message = null;
                message = id == originalId ? "Duplicate options for " + this.describeDualOption(originalId) + " found." : "Incompatible options -" + this.describeDualOption(id) + " and " + this.describeDualOption(originalId) + " found.";
                throw new ParseException(message, 0);
            }
        }
    }

    private String describeDualOption(int id) {
        String longOption;
        CLOptionDescriptor descriptor = this.getDescriptorFor(id);
        if (null == descriptor) {
            return "<parameter>";
        }
        StringBuilder sb = new StringBuilder();
        boolean hasCharOption = false;
        if (Character.isLetter((char)id)) {
            sb.append('-');
            sb.append((char)id);
            hasCharOption = true;
        }
        if (null != (longOption = descriptor.getName())) {
            if (hasCharOption) {
                sb.append('/');
            }
            sb.append("--");
            sb.append(longOption);
        }
        return sb.toString();
    }

    public CLArgsParser(String[] args2, CLOptionDescriptor[] optionDescriptors) {
        this(args2, optionDescriptors, null);
    }

    private static String[] subArray(String[] array, int index, int charIndex) {
        int remaining = array.length - index;
        String[] result = new String[remaining];
        if (remaining > 1) {
            System.arraycopy(array, index + 1, result, 1, remaining - 1);
        }
        result[0] = array[index].substring(charIndex - 1);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse() throws ParseException {
        if (0 == this.args.length) {
            return;
        }
        this.stringLength = this.args[this.argIndex].length();
        while (true) {
            this.ch = this.peekAtChar();
            if (this.argIndex >= this.args.length) break;
            if (null != this.control && this.control.isFinished(this.lastOptionId)) {
                this.unparsedArgs = CLArgsParser.subArray(this.args, this.argIndex, this.stringIndex);
                return;
            }
            if (5 == this.state) {
                if ('\u0000' == this.ch) {
                    this.getChar();
                    this.state = 0;
                    continue;
                }
                this.parseShortOption();
                continue;
            }
            if (0 == this.state) {
                this.parseNormal();
                continue;
            }
            if (4 == this.state) {
                this.addOption(new CLOption(this.args[this.argIndex++]));
                continue;
            }
            this.parseArguments();
        }
        if (this.option == null) return;
        if (3 == this.state) {
            this.options.add(this.option);
            return;
        } else {
            if (2 == this.state) {
                CLOptionDescriptor descriptor = this.getDescriptorFor(this.option.getDescriptor().getId());
                String message = "Missing argument to option " + this.getOptionDescription(descriptor);
                throw new ParseException(message, 0);
            }
            if (1 != this.state) throw new ParseException("IllegalState " + this.state + ": " + this.option, 0);
            if (1 == this.option.getArgumentCount()) {
                this.option.addArgument("");
                this.options.add(this.option);
                return;
            } else {
                CLOptionDescriptor descriptor = this.getDescriptorFor(this.option.getDescriptor().getId());
                String message = "Missing argument to option " + this.getOptionDescription(descriptor);
                throw new ParseException(message, 0);
            }
        }
    }

    private String getOptionDescription(CLOptionDescriptor descriptor) {
        if (this.isLong) {
            return "--" + descriptor.getName();
        }
        return "-" + (char)descriptor.getId();
    }

    private char peekAtChar() {
        if (Integer.MAX_VALUE == this.lastChar) {
            this.lastChar = this.readChar();
        }
        return (char)this.lastChar;
    }

    private char getChar() {
        if (Integer.MAX_VALUE != this.lastChar) {
            char result = (char)this.lastChar;
            this.lastChar = Integer.MAX_VALUE;
            return result;
        }
        return this.readChar();
    }

    private char readChar() {
        if (this.stringIndex >= this.stringLength) {
            ++this.argIndex;
            this.stringIndex = 0;
            this.stringLength = this.argIndex < this.args.length ? this.args[this.argIndex].length() : 0;
            return '\u0000';
        }
        if (this.argIndex >= this.args.length) {
            return '\u0000';
        }
        return this.args[this.argIndex].charAt(this.stringIndex++);
    }

    private Token nextToken(char[] separators) {
        this.ch = this.getChar();
        if (CLArgsParser.isSeparator(this.ch, separators)) {
            this.tokesep = this.ch;
            this.ch = this.getChar();
            return new Token(0, null);
        }
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(this.ch);
            this.ch = this.getChar();
        } while (!CLArgsParser.isSeparator(this.ch, separators));
        this.tokesep = this.ch;
        return new Token(1, sb.toString());
    }

    private static boolean isSeparator(char ch, char[] separators) {
        for (char separator : separators) {
            if (ch != separator) continue;
            return true;
        }
        return false;
    }

    private void addOption(CLOption option) {
        this.options.add(option);
        this.lastOptionId = option.getDescriptor().getId();
        this.option = null;
    }

    private void parseOption(CLOptionDescriptor descriptor, String optionString) throws ParseException {
        if (null == descriptor) {
            throw new ParseException("Unknown option " + optionString, 0);
        }
        this.state = CLArgsParser.getStateFor(descriptor);
        this.option = new CLOption(descriptor);
        if (0 == this.state) {
            this.addOption(this.option);
        }
    }

    private void parseShortOption() throws ParseException {
        this.ch = this.getChar();
        CLOptionDescriptor descriptor = this.getDescriptorFor(this.ch);
        this.isLong = false;
        this.parseOption(descriptor, "-" + this.ch);
        if (0 == this.state) {
            this.state = 5;
        }
    }

    private void parseArguments() throws ParseException {
        if (2 == this.state) {
            if ('=' == this.ch || '\u0000' == this.ch) {
                this.getChar();
            }
            Token token = this.nextToken(NULL_SEPARATORS);
            this.option.addArgument(token.getValue());
            this.addOption(this.option);
            this.state = 0;
        } else if (3 == this.state) {
            if ('-' == this.ch || '\u0000' == this.ch) {
                this.getChar();
                this.addOption(this.option);
                this.state = 0;
                return;
            }
            if (this.isLong && '=' != this.tokesep) {
                this.addOption(this.option);
                this.state = 0;
                return;
            }
            if ('=' == this.ch) {
                this.getChar();
            }
            Token token = this.nextToken(NULL_SEPARATORS);
            this.option.addArgument(token.getValue());
            this.addOption(this.option);
            this.state = 0;
        } else if (1 == this.state) {
            if (0 == this.option.getArgumentCount()) {
                Token token;
                if (!this.isLong && '\u0000' == this.peekAtChar()) {
                    this.getChar();
                }
                if (0 == (token = this.nextToken(ARG_SEPARATORS)).getType()) {
                    CLOptionDescriptor descriptor = this.getDescriptorFor(this.option.getDescriptor().getId());
                    String message = "Unable to parse first argument for option " + this.getOptionDescription(descriptor);
                    throw new ParseException(message, 0);
                }
                this.option.addArgument(token.getValue());
                if ('\u0000' == this.ch && '-' == this.peekAtChar()) {
                    this.option.addArgument("");
                    this.options.add(this.option);
                    this.state = 0;
                }
            } else {
                StringBuilder sb = new StringBuilder();
                this.ch = this.getChar();
                while (!CLArgsParser.isSeparator(this.ch, NULL_SEPARATORS)) {
                    sb.append(this.ch);
                    this.ch = this.getChar();
                }
                String argument = sb.toString();
                this.option.addArgument(argument);
                this.addOption(this.option);
                this.option = null;
                this.state = 0;
            }
        }
    }

    private void parseNormal() throws ParseException {
        if ('-' != this.ch) {
            String argument = this.nextToken(NULL_SEPARATORS).getValue();
            this.addOption(new CLOption(argument));
            this.state = 0;
        } else {
            this.getChar();
            if ('\u0000' == this.peekAtChar()) {
                throw new ParseException("Malformed option -", 0);
            }
            this.ch = this.peekAtChar();
            if ('-' != this.ch) {
                this.parseShortOption();
            } else {
                this.getChar();
                if ('\u0000' == this.peekAtChar()) {
                    this.getChar();
                    this.state = 4;
                } else {
                    String optionName = this.nextToken(ARG_SEPARATORS).getValue();
                    CLOptionDescriptor descriptor = this.getDescriptorFor(optionName);
                    this.isLong = true;
                    this.parseOption(descriptor, "--" + optionName);
                }
            }
        }
    }

    private void buildOptionIndex() {
        int size = this.options.size();
        this.optionIndex = new HashMap<Object, CLOption>(size * 2);
        for (CLOption option : this.options) {
            CLOptionDescriptor optionDescriptor = this.getDescriptorFor(option.getDescriptor().getId());
            this.optionIndex.put(option.getDescriptor().getId(), option);
            if (null == optionDescriptor || null == optionDescriptor.getName()) continue;
            this.optionIndex.put(optionDescriptor.getName(), option);
        }
    }
}

