/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.ObjectTableModel;

public class RowDetailDialog
extends JDialog
implements ActionListener,
DocumentListener,
ItemListener {
    private static final long serialVersionUID = 6578889215615435475L;
    private static final String NEXT = "next";
    private static final String PREVIOUS = "previous";
    private static final String CLOSE = "close";
    private static final String UPDATE = "update";
    private List<JComponent> dataComponents;
    private JButton nextButton;
    private JButton previousButton;
    private JButton closeButton;
    private ObjectTableModel tableModel;
    private int selectedRow;
    private boolean textChanged = true;

    public RowDetailDialog() {
    }

    public RowDetailDialog(ObjectTableModel tableModel, int selectedRow) {
        super((Frame)null, JMeterUtils.getResString("detail"), true);
        this.tableModel = tableModel;
        this.selectedRow = selectedRow;
        this.init();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -8699034338969407625L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowDetailDialog.this.setVisible(false);
            }
        };
        AbstractAction enterAction = new AbstractAction("ENTER"){
            private static final long serialVersionUID = -1529005452976176873L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowDetailDialog.this.doUpdate(actionEvent);
                RowDetailDialog.this.setVisible(false);
            }
        };
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escapeAction.getValue("Name"), escapeAction);
        actionMap.put(enterAction.getValue("Name"), enterAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        inputMap.put(KeyStrokes.ENTER, enterAction.getValue("Name"));
        return rootPane;
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel dataPanel = new JPanel(new MigLayout("fillx, wrap 2", "[][fill, grow]"));
        this.dataComponents = new ArrayList<JComponent>();
        int columnCount = this.tableModel.getColumnCount();
        int linesPerTextArea = Math.max(5, 30 / Math.max(columnCount - 1, 1));
        for (int column = 0; column < columnCount; ++column) {
            JLabel dataLabel = new JLabel(JMeterUtils.getResString(this.tableModel.getColumnName(column)));
            dataPanel.add(dataLabel);
            JComponent component = this.createComponentForRow(columnCount, linesPerTextArea, column, this.tableModel.getValueAt(this.selectedRow, column));
            dataPanel.add(component);
            dataLabel.setLabelFor(component);
        }
        this.setValues(this.selectedRow);
        JPanel mainPanel = new JPanel(new MigLayout());
        mainPanel.add((Component)dataPanel, "wrap");
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        JButton updateButton = new JButton(JMeterUtils.getResString(UPDATE));
        updateButton.setActionCommand(UPDATE);
        updateButton.addActionListener(this);
        this.closeButton = new JButton(JMeterUtils.getResString(CLOSE));
        this.closeButton.setActionCommand(CLOSE);
        this.closeButton.addActionListener(this);
        this.nextButton = new JButton(JMeterUtils.getResString(NEXT));
        this.nextButton.setActionCommand(NEXT);
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(this.selectedRow < this.tableModel.getRowCount() - 1);
        this.previousButton = new JButton(JMeterUtils.getResString(PREVIOUS));
        this.previousButton.setActionCommand(PREVIOUS);
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(this.selectedRow > 0);
        buttonsPanel.add(updateButton);
        buttonsPanel.add(this.previousButton);
        buttonsPanel.add(this.nextButton);
        buttonsPanel.add(this.closeButton);
        mainPanel.add((Component)buttonsPanel, "center");
        this.getContentPane().add(mainPanel);
        this.dataComponents.get(0).requestFocusInWindow();
        this.pack();
        ComponentUtil.centerComponentInWindow(this);
    }

    private JComponent createComponentForRow(int columnCount, int linesPerTextArea, int column, Object value) {
        if (column > 0 || columnCount == 1) {
            if (this.tableModel.getColumnClass(column).equals(Boolean.class)) {
                JCheckBox checkBox = new JCheckBox();
                if (value instanceof Boolean) {
                    checkBox.setSelected((Boolean)value);
                }
                checkBox.addItemListener(this);
                this.dataComponents.add(checkBox);
                return checkBox;
            }
            JSyntaxTextArea dataArea = JSyntaxTextArea.getInstance(linesPerTextArea, 80);
            if (value instanceof String) {
                dataArea.setInitialText((String)value);
            }
            dataArea.getDocument().addDocumentListener(this);
            this.dataComponents.add(dataArea);
            return JTextScrollPane.getInstance(dataArea);
        }
        JTextField nameTF = new JTextField("");
        if (value instanceof String) {
            nameTF.setText((String)value);
        }
        nameTF.getDocument().addDocumentListener(this);
        this.dataComponents.add(nameTF);
        return nameTF;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(CLOSE)) {
            this.setVisible(false);
        } else if (action.equals(NEXT)) {
            ++this.selectedRow;
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(this.selectedRow < this.tableModel.getRowCount() - 1);
            this.setValues(this.selectedRow);
        } else if (action.equals(PREVIOUS)) {
            --this.selectedRow;
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(this.selectedRow > 0);
            this.setValues(this.selectedRow);
        } else if (action.equals(UPDATE)) {
            this.doUpdate(e);
        }
    }

    private void setValues(int selectedRow) {
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            JComponent component = this.dataComponents.get(i);
            if (component instanceof JTextComponent) {
                JTextComponent dataArea = (JTextComponent)component;
                dataArea.setText((String)this.tableModel.getValueAt(selectedRow, i));
                if (!(dataArea instanceof JSyntaxTextArea)) continue;
                dataArea.setCaretPosition(0);
                continue;
            }
            if (!(component instanceof JCheckBox)) continue;
            ((JCheckBox)component).setSelected((Boolean)this.tableModel.getValueAt(selectedRow, i));
        }
        this.textChanged = false;
    }

    protected void doUpdate(ActionEvent actionEvent) {
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            JComponent component = this.dataComponents.get(i);
            if (component instanceof JTextComponent) {
                this.tableModel.setValueAt(((JTextComponent)component).getText(), this.selectedRow, i);
                continue;
            }
            if (!(component instanceof JCheckBox)) continue;
            this.tableModel.setValueAt(((JCheckBox)component).isSelected(), this.selectedRow, i);
        }
        this.closeButton.setText(JMeterUtils.getResString(CLOSE));
        this.textChanged = false;
    }

    private void changeLabelButton() {
        if (!this.textChanged) {
            this.closeButton.setText(JMeterUtils.getResString("cancel"));
            this.textChanged = true;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changeLabelButton();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changeLabelButton();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changeLabelButton();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.changeLabelButton();
    }
}

