/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.JBooleanPropertyEditor;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.FileListPanel;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.TestPlanSchema;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="test_plan", actionGroups={""})
public class TestPlanGui
extends AbstractJMeterGuiComponent {
    private static final long serialVersionUID = 240L;
    private final JBooleanPropertyEditor functionalMode = new JBooleanPropertyEditor(TestPlanSchema.INSTANCE.getFunctionalMode(), JMeterUtils.getResString("functional_mode"));
    private final JBooleanPropertyEditor serializedMode = new JBooleanPropertyEditor(TestPlanSchema.INSTANCE.getSerializeThreadgroups(), JMeterUtils.getResString("testplan.serialized"));
    private final JBooleanPropertyEditor tearDownOnShutdown = new JBooleanPropertyEditor(TestPlanSchema.INSTANCE.getTearDownOnShutdown(), JMeterUtils.getResString("teardown_on_shutdown"));
    private final ArgumentsPanel argsPanel;
    private final FileListPanel browseJar = new FileListPanel(JMeterUtils.getResString("test_plan_classpath_browse"), ".jar");

    public TestPlanGui() {
        this.argsPanel = new ArgumentsPanel(JMeterUtils.getResString("user_defined_variables"));
        this.init();
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        JMenu addMenu = new JMenu(JMeterUtils.getResString("add"));
        addMenu.add(MenuFactory.makeMenu("menu_threads", "Add"));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu("menu_config_element", "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_listener", "Add"));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu("menu_timer", "Add"));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu("menu_pre_processors", "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_post_processors", "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_assertions", "Add"));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu("menu_fragments", "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_non_test_elements", "Add"));
        pop.add(addMenu);
        MenuFactory.addPasteResetMenu(pop);
        MenuFactory.addFileMenu(pop, false);
        return pop;
    }

    @Override
    public TestElement createTestElement() {
        TestPlan tp = new TestPlan();
        this.modifyTestElement(tp);
        return tp;
    }

    @Override
    public void modifyTestElement(TestElement plan) {
        super.configureTestElement(plan);
        if (plan instanceof TestPlan) {
            TestPlan tp = (TestPlan)plan;
            this.functionalMode.updateElement(tp);
            this.tearDownOnShutdown.updateElement(tp);
            this.serializedMode.updateElement(tp);
            tp.setUserDefinedVariables((Arguments)this.argsPanel.createTestElement());
            tp.setTestPlanClasspathArray(this.browseJar.getFiles());
        }
    }

    @Override
    public String getLabelResource() {
        return "test_plan";
    }

    @Override
    public Collection<String> getMenuCategories() {
        return null;
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof TestPlan) {
            TestPlan tp = (TestPlan)el;
            this.functionalMode.updateUi(tp);
            this.serializedMode.updateUi(tp);
            this.tearDownOnShutdown.updateUi(tp);
            JMeterProperty udv = tp.getUserDefinedVariablesAsProperty();
            if (udv != null) {
                this.argsPanel.configure((Arguments)udv.getObjectValue());
            }
            this.browseJar.setFiles(tp.getTestPlanClasspathArray());
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        this.add((Component)this.argsPanel, "Center");
        VerticalPanel southPanel = new VerticalPanel();
        southPanel.add(this.serializedMode);
        southPanel.add(this.tearDownOnShutdown);
        southPanel.add(this.functionalMode);
        JLabel explain = new JLabel(JMeterUtils.getResString("functional_mode_explanation"));
        southPanel.add(explain);
        southPanel.add(this.browseJar);
        this.add((Component)southPanel, "South");
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.functionalMode.reset();
        this.serializedMode.reset();
        this.tearDownOnShutdown.reset();
        this.argsPanel.clear();
        this.browseJar.clearFiles();
    }
}

