/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.ClientJMeterEngine;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.PreCompiler;
import org.apache.jmeter.engine.TurnElementsOn;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.PostThreadGroup;
import org.apache.jmeter.threads.SetupThreadGroup;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.util.JMeterStopTestException;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardJMeterEngine
implements JMeterEngine,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(StandardJMeterEngine.class);
    private static final boolean EXIT_AFTER_TEST = JMeterUtils.getPropDefault("server.exitaftertest", false);
    private static volatile StandardJMeterEngine engine;
    private static final List<TestStateListener> testList;
    private static final boolean REMOTE_SYSTEM_EXIT;
    private static final boolean SYSTEM_EXIT_ON_STOP_FAIL;
    private static final boolean SYSTEM_EXIT_FORCED;
    private static final AtomicInteger THREAD_COUNTER;
    private static final ExecutorService EXECUTOR_SERVICE;
    private volatile Future<?> runningTest;
    private volatile boolean running = false;
    private volatile boolean active = false;
    private volatile boolean serialized = false;
    private volatile boolean tearDownOnShutdown = false;
    private HashTree test;
    private final String host;
    private final List<AbstractThreadGroup> groups = new CopyOnWriteArrayList<AbstractThreadGroup>();

    public StandardJMeterEngine() {
        this(null);
    }

    public StandardJMeterEngine(String host) {
        this.host = host;
        StandardJMeterEngine.initSingletonEngine(this);
    }

    private static void initSingletonEngine(StandardJMeterEngine standardJMeterEngine) {
        engine = standardJMeterEngine;
    }

    public static void stopEngineNow() {
        if (engine != null) {
            engine.stopTest(true);
        }
    }

    public static void stopEngine() {
        if (engine != null) {
            engine.stopTest(false);
        }
    }

    public static synchronized void register(TestStateListener tl) {
        testList.add(tl);
    }

    public static boolean stopThread(String threadName) {
        return StandardJMeterEngine.stopThread(threadName, false);
    }

    public static boolean stopThreadNow(String threadName) {
        return StandardJMeterEngine.stopThread(threadName, true);
    }

    private static boolean stopThread(String threadName, boolean now) {
        if (engine == null) {
            return false;
        }
        boolean wasStopped = false;
        for (AbstractThreadGroup threadGroup : StandardJMeterEngine.engine.groups) {
            wasStopped = wasStopped || threadGroup.stopThread(threadName, now);
        }
        return wasStopped;
    }

    @Override
    public void configure(HashTree testTree) {
        SearchByClass<TestPlan> testPlan = new SearchByClass<TestPlan>(TestPlan.class);
        testTree.traverse(testPlan);
        Object[] plan = testPlan.getSearchResults().toArray();
        if (plan.length == 0) {
            throw new IllegalStateException("Could not find the TestPlan class!");
        }
        TestPlan tp = (TestPlan)plan[0];
        this.serialized = tp.isSerialized();
        this.tearDownOnShutdown = tp.isTearDownOnShutdown();
        this.active = true;
        this.test = testTree;
    }

    @Override
    public void runTest() throws JMeterEngineException {
        if (this.host != null) {
            Instant now = Instant.now();
            String nowAsString = StandardJMeterEngine.formatLikeDate(now);
            System.out.println("Starting the test on host " + this.host + " @ " + nowAsString + " (" + now.toEpochMilli() + ')');
        }
        try {
            this.runningTest = EXECUTOR_SERVICE.submit(this);
        }
        catch (Exception err) {
            this.stopTest();
            throw new JMeterEngineException(err);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.6")
    public void awaitTermination(Duration duration) throws ExecutionException, InterruptedException, TimeoutException {
        this.runningTest.get(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static String formatLikeDate(Instant instant) {
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withLocale(Locale.ROOT).withZone(ZoneId.systemDefault()).format(instant);
    }

    private static void removeThreadGroups(List<?> elements) {
        Iterator<?> iter = elements.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof AbstractThreadGroup) && item instanceof TestElement) continue;
            iter.remove();
        }
    }

    private void notifyTestListenersOfStart(SearchByClass<? extends TestStateListener> testListeners) {
        for (TestStateListener testStateListener : testListeners.getSearchResults()) {
            if (testStateListener instanceof TestBean) {
                TestBeanHelper.prepare((TestElement)((Object)testStateListener));
            }
            if (this.host == null) {
                testStateListener.testStarted();
                continue;
            }
            testStateListener.testStarted(this.host);
        }
    }

    private void notifyTestListenersOfEnd(SearchByClass<? extends TestStateListener> testListeners) {
        log.info("Notifying test listeners of end of test");
        for (TestStateListener testStateListener : testListeners.getSearchResults()) {
            try {
                if (this.host == null) {
                    testStateListener.testEnded();
                    continue;
                }
                testStateListener.testEnded(this.host);
            }
            catch (Exception e) {
                log.warn("Error encountered during shutdown of " + testStateListener.toString(), e);
            }
        }
        if (this.host != null) {
            log.info("Test has ended on host {} ", (Object)this.host);
            Instant now = Instant.now();
            String string = StandardJMeterEngine.formatLikeDate(now);
            System.out.println("Finished the test on host " + this.host + " @ " + string + " (" + now.toEpochMilli() + ')' + (EXIT_AFTER_TEST ? " - exit requested." : ""));
            if (EXIT_AFTER_TEST) {
                this.exit();
            }
        }
        this.active = false;
    }

    @Override
    public void reset() {
        if (this.running) {
            this.stopTest();
        }
    }

    @Override
    public synchronized void stopTest() {
        this.stopTest(true);
    }

    @Override
    public synchronized void stopTest(boolean now) {
        EXECUTOR_SERVICE.submit(new StopTest(now));
    }

    @Override
    public void run() {
        String groupName;
        AbstractThreadGroup group;
        log.info("Running the test!");
        this.running = true;
        SampleEvent.initSampleVariables();
        JMeterContextService.startTest();
        try {
            PreCompiler compiler = new PreCompiler();
            this.test.traverse(compiler);
        }
        catch (RuntimeException e) {
            log.error("Error occurred compiling the tree:", e);
            JMeterUtils.reportErrorToUser("Error occurred compiling the tree: - see log file", e);
            return;
        }
        SearchByClass<TestStateListener> testListeners = new SearchByClass<TestStateListener>(TestStateListener.class);
        this.test.traverse(testListeners);
        testListeners.getSearchResults().addAll(testList);
        testList.clear();
        this.test.traverse(new TurnElementsOn());
        this.notifyTestListenersOfStart(testListeners);
        ArrayList testLevelElements = new ArrayList(this.test.list(this.test.getArray()[0]));
        StandardJMeterEngine.removeThreadGroups(testLevelElements);
        SearchByClass<SetupThreadGroup> setupSearcher = new SearchByClass<SetupThreadGroup>(SetupThreadGroup.class);
        SearchByClass<AbstractThreadGroup> searcher = new SearchByClass<AbstractThreadGroup>(AbstractThreadGroup.class);
        SearchByClass<PostThreadGroup> postSearcher = new SearchByClass<PostThreadGroup>(PostThreadGroup.class);
        this.test.traverse(setupSearcher);
        this.test.traverse(searcher);
        this.test.traverse(postSearcher);
        TestCompiler.initialize();
        Iterator<SetupThreadGroup> setupIter = setupSearcher.getSearchResults().iterator();
        Iterator<AbstractThreadGroup> iter = searcher.getSearchResults().iterator();
        Iterator<PostThreadGroup> postIter = postSearcher.getSearchResults().iterator();
        ListenerNotifier notifier = new ListenerNotifier();
        int groupCount = 0;
        JMeterContextService.clearTotalThreads();
        if (setupIter.hasNext()) {
            log.info("Starting setUp thread groups");
            while (this.running && setupIter.hasNext()) {
                AbstractThreadGroup group2 = setupIter.next();
                String groupName2 = group2.getName();
                log.info("Starting setUp ThreadGroup: {} : {} ", (Object)(++groupCount), (Object)groupName2);
                this.startThreadGroup(group2, groupCount, setupSearcher, testLevelElements, notifier);
                if (!this.serialized || !setupIter.hasNext()) continue;
                log.info("Waiting for setup thread group: {} to finish before starting next setup group", (Object)groupName2);
                group2.waitThreadsStopped();
            }
            log.info("Waiting for all setup thread groups to exit");
            this.waitThreadsStopped();
            log.info("All Setup Threads have ended");
            groupCount = 0;
            JMeterContextService.clearTotalThreads();
        }
        this.groups.clear();
        JMeterUtils.helpGC();
        JMeterContextService.getContext().setSamplingStarted(true);
        boolean mainGroups = this.running;
        while (this.running && iter.hasNext()) {
            group = iter.next();
            if (group instanceof SetupThreadGroup || group instanceof PostThreadGroup) continue;
            groupName = group.getName();
            log.info("Starting ThreadGroup: {} : {}", (Object)(++groupCount), (Object)groupName);
            this.startThreadGroup(group, groupCount, searcher, testLevelElements, notifier);
            if (!this.serialized || !iter.hasNext()) continue;
            log.info("Waiting for thread group: {} to finish before starting next group", (Object)groupName);
            group.waitThreadsStopped();
        }
        if (groupCount == 0) {
            log.info("No enabled thread groups found");
        } else if (this.running) {
            log.info("All thread groups have been started");
        } else {
            log.info("Test stopped - no more thread groups will be started");
        }
        this.waitThreadsStopped();
        this.groups.clear();
        if (postIter.hasNext()) {
            groupCount = 0;
            JMeterContextService.clearTotalThreads();
            log.info("Starting tearDown thread groups");
            if (mainGroups && !this.running) {
                this.running = this.tearDownOnShutdown;
            }
            while (this.running && postIter.hasNext()) {
                group = postIter.next();
                groupName = group.getName();
                log.info("Starting tearDown ThreadGroup: {} : {}", (Object)(++groupCount), (Object)groupName);
                this.startThreadGroup(group, groupCount, postSearcher, testLevelElements, notifier);
                if (!this.serialized || !postIter.hasNext()) continue;
                log.info("Waiting for post thread group: {} to finish before starting next post group", (Object)groupName);
                group.waitThreadsStopped();
            }
            this.waitThreadsStopped();
        }
        this.notifyTestListenersOfEnd(testListeners);
        JMeterContextService.endTest();
        if (JMeter.isNonGUI() && SYSTEM_EXIT_FORCED) {
            log.info("Forced JVM shutdown requested at end of test");
            System.exit(0);
        }
    }

    private void startThreadGroup(AbstractThreadGroup group, int groupCount, SearchByClass<?> searcher, List<?> testLevelElements, ListenerNotifier notifier) {
        try {
            int numThreads = group.getNumThreads();
            JMeterContextService.addTotalThreads(numThreads);
            boolean onErrorStopTest = group.getOnErrorStopTest();
            boolean onErrorStopTestNow = group.getOnErrorStopTestNow();
            boolean onErrorStopThread = group.getOnErrorStopThread();
            boolean onErrorStartNextLoop = group.getOnErrorStartNextLoop();
            String groupName = group.getName();
            log.info("Starting {} threads for group {}.", (Object)numThreads, (Object)groupName);
            if (onErrorStopTest) {
                log.info("Test will stop on error");
            } else if (onErrorStopTestNow) {
                log.info("Test will stop abruptly on error");
            } else if (onErrorStopThread) {
                log.info("Thread will stop on error");
            } else if (onErrorStartNextLoop) {
                log.info("Thread will start next loop on error");
            } else {
                log.info("Thread will continue on error");
            }
            ListedHashTree threadGroupTree = (ListedHashTree)searcher.getSubTree(group);
            threadGroupTree.add((Object)group, testLevelElements);
            this.groups.add(group);
            group.start(groupCount, notifier, threadGroupTree, this);
        }
        catch (JMeterStopTestException ex) {
            JMeterUtils.reportErrorToUser("Error occurred starting thread group :" + group.getName() + ", error message:" + ex.getMessage() + ", \r\nsee log file for more details", ex);
            return;
        }
    }

    private void waitThreadsStopped() {
        for (AbstractThreadGroup threadGroup : this.groups) {
            threadGroup.waitThreadsStopped();
        }
    }

    public void askThreadsToStop() {
        if (engine != null) {
            engine.stopTest(false);
        }
    }

    @Override
    public void exit() {
        ClientJMeterEngine.tidyRMI(log);
        if (REMOTE_SYSTEM_EXIT) {
            log.warn("About to run System.exit(0) on {}", (Object)this.host);
            EXECUTOR_SERVICE.submit(() -> {
                StandardJMeterEngine.pause(1000L);
                log.info("Bye from {}", (Object)this.host);
                System.out.println("Bye from " + this.host);
                System.exit(0);
            });
        }
    }

    private static void pause(long ms) {
        try {
            TimeUnit.MILLISECONDS.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void setProperties(Properties p) {
        log.info("Applying properties {}", (Object)p);
        JMeterUtils.getJMeterProperties().putAll((Map<?, ?>)p);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    static {
        testList = new ArrayList<TestStateListener>();
        REMOTE_SYSTEM_EXIT = JMeterUtils.getPropDefault("jmeterengine.remote.system.exit", false);
        SYSTEM_EXIT_ON_STOP_FAIL = JMeterUtils.getPropDefault("jmeterengine.stopfail.system.exit", true);
        SYSTEM_EXIT_FORCED = JMeterUtils.getPropDefault("jmeterengine.force.system.exit", false);
        THREAD_COUNTER = new AtomicInteger(0);
        EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), runnable2 -> new Thread(runnable2, "StandardJMeterEngine-" + THREAD_COUNTER.incrementAndGet()));
    }

    private class StopTest
    implements Runnable {
        private final boolean now;

        private StopTest(boolean b) {
            this.now = b;
        }

        private void stopAllThreadGroups() {
            for (AbstractThreadGroup threadGroup : StandardJMeterEngine.this.groups) {
                threadGroup.stop();
            }
        }

        private void tellThreadGroupsToStop() {
            for (AbstractThreadGroup threadGroup : StandardJMeterEngine.this.groups) {
                threadGroup.tellThreadsToStop();
            }
        }

        private boolean verifyThreadsStopped() {
            for (AbstractThreadGroup threadGroup : StandardJMeterEngine.this.groups) {
                if (threadGroup.verifyThreadsStopped()) continue;
                return false;
            }
            return true;
        }

        private int countStillActiveThreads() {
            int reminingThreads = 0;
            for (AbstractThreadGroup threadGroup : StandardJMeterEngine.this.groups) {
                reminingThreads += threadGroup.numberOfActiveThreads();
            }
            return reminingThreads;
        }

        private void resetSingletonEngine() {
            engine = null;
        }

        @Override
        public void run() {
            StandardJMeterEngine.this.running = false;
            this.resetSingletonEngine();
            if (this.now) {
                this.tellThreadGroupsToStop();
                StandardJMeterEngine.pause(10L * (long)this.countStillActiveThreads());
                boolean stopped = this.verifyThreadsStopped();
                if (!stopped) {
                    if (JMeter.isNonGUI()) {
                        log.error(JMeterUtils.getResString("stopping_test_failed"));
                        if (SYSTEM_EXIT_ON_STOP_FAIL) {
                            log.error("Exiting");
                            System.out.println("Fatal error, could not stop test, exiting");
                            System.exit(1);
                        } else {
                            System.out.println("Fatal error, could not stop test");
                        }
                    } else {
                        JMeterUtils.reportErrorToUser(JMeterUtils.getResString("stopping_test_failed"), JMeterUtils.getResString("stopping_test_title"));
                    }
                }
            } else {
                this.stopAllThreadGroups();
            }
        }
    }
}

