/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.LogAndIgnoreServiceLoadExceptionHandler;
import org.apache.jorphan.util.JMeterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionRouter
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(ActionRouter.class);
    private static final ActionRouter INSTANCE = new ActionRouter();
    private final Map<String, Set<Command>> commands = new HashMap<String, Set<Command>>();
    private final Map<String, Set<ActionListener>> preActionListeners = new HashMap<String, Set<ActionListener>>();
    private final Map<String, Set<ActionListener>> postActionListeners = new HashMap<String, Set<ActionListener>>();
    private final List<String> NO_TRANSACTION_ACTIONS = Arrays.asList("close", "open", "open_recent");

    private ActionRouter() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(() -> this.performAction(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAction(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (!this.NO_TRANSACTION_ACTIONS.contains(actionCommand)) {
            GuiPackage.getInstance().beginUndoTransaction();
        }
        try {
            try {
                GuiPackage.getInstance().updateCurrentGui();
            }
            catch (Exception err) {
                log.error("performAction({}) updateCurrentGui() on{} caused", actionCommand, e, err);
                JMeterUtils.reportErrorToUser("Problem updating GUI - see log file for details");
            }
            for (Command c : this.commands.get(actionCommand)) {
                try {
                    this.preActionPerformed(c.getClass(), e);
                    c.doAction(e);
                    this.postActionPerformed(c.getClass(), e);
                }
                catch (IllegalUserActionException err) {
                    Throwable t;
                    String msg = err.getMessage();
                    if (msg == null) {
                        msg = err.toString();
                    }
                    if ((t = err.getCause()) != null) {
                        String cause = t.getMessage();
                        if (cause == null) {
                            cause = t.toString();
                        }
                        msg = msg + "\n" + cause;
                    }
                    JMeterUtils.reportErrorToUser(msg);
                }
                catch (Exception err) {
                    log.error("Error processing {}", (Object)c, (Object)err);
                }
            }
        }
        catch (NullPointerException er) {
            log.error("performAction({}) {} caused", actionCommand, e, er);
            JMeterUtils.reportErrorToUser("Sorry, this feature (" + actionCommand + ") not yet implemented");
        }
        finally {
            if (!this.NO_TRANSACTION_ACTIONS.contains(actionCommand)) {
                GuiPackage.getInstance().endUndoTransaction();
            }
        }
    }

    public void doActionNow(ActionEvent e) {
        this.performAction(e);
    }

    public Set<Command> getAction(String actionName) {
        HashSet<Command> set = new HashSet<Command>();
        for (Command c : this.commands.get(actionName)) {
            try {
                set.add(c);
            }
            catch (Exception err) {
                log.error("Could not add Command", err);
            }
        }
        return set;
    }

    public Command getAction(String actionName, Class<?> actionClass) {
        for (Command com : this.commands.get(actionName)) {
            if (!com.getClass().equals(actionClass)) continue;
            return com;
        }
        return null;
    }

    public Command getAction(String actionName, String className) {
        for (Command com : this.commands.get(actionName)) {
            if (!com.getClass().getName().equals(className)) continue;
            return com;
        }
        return null;
    }

    public void addPreActionListener(Class<?> action, ActionListener listener) {
        ActionRouter.addActionListener(action, listener, this.preActionListeners);
    }

    public void removePreActionListener(Class<?> action, ActionListener listener) {
        ActionRouter.removeActionListener(action, listener, this.preActionListeners);
    }

    private static void removeActionListener(Class<?> action, ActionListener listener, Map<? super String, Set<ActionListener>> actionListeners) {
        Set<ActionListener> set;
        if (action != null && (set = actionListeners.get(action.getName())) != null) {
            set.remove(listener);
            actionListeners.put(action.getName(), set);
        }
    }

    public void addPostActionListener(Class<?> action, ActionListener listener) {
        ActionRouter.addActionListener(action, listener, this.postActionListeners);
    }

    private static void addActionListener(Class<?> action, ActionListener listener, Map<? super String, Set<ActionListener>> actionListeners) {
        if (action != null) {
            Set<ActionListener> set = actionListeners.get(action.getName());
            if (set == null) {
                set = new HashSet<ActionListener>();
            }
            set.add(listener);
            actionListeners.put(action.getName(), set);
        }
    }

    public void removePostActionListener(Class<?> action, ActionListener listener) {
        ActionRouter.removeActionListener(action, listener, this.postActionListeners);
    }

    void preActionPerformed(Class<? extends Command> action, ActionEvent e) {
        ActionRouter.actionPerformed(action, e, this.preActionListeners);
    }

    void postActionPerformed(Class<? extends Command> action, ActionEvent e) {
        ActionRouter.actionPerformed(action, e, this.postActionListeners);
    }

    private static void actionPerformed(Class<? extends Command> action, ActionEvent e, Map<String, ? extends Set<ActionListener>> actionListeners) {
        Set<ActionListener> listenerSet;
        if (action != null && (listenerSet = actionListeners.get(action.getName())) != null && !listenerSet.isEmpty()) {
            ActionListener[] listeners;
            for (ActionListener listener : listeners = listenerSet.toArray(new ActionListener[listenerSet.size()])) {
                listener.actionPerformed(e);
            }
        }
    }

    public void populateCommandMap() {
        if (!this.commands.isEmpty()) {
            return;
        }
        try {
            Collection<Object> commandServices = JMeterUtils.loadServicesAndScanJars(Command.class, ServiceLoader.load(Command.class), Thread.currentThread().getContextClassLoader(), new LogAndIgnoreServiceLoadExceptionHandler(log));
            if (commandServices.isEmpty()) {
                String message = "No implementations of " + Command.class + " found. Please ensure the classpath contains JMeter commands";
                log.error(message);
                throw new JMeterError(message);
            }
            for (Command command : commandServices) {
                for (String commandName : command.getActionNames()) {
                    Set commandObjects = this.commands.computeIfAbsent(commandName, k -> new HashSet());
                    commandObjects.add(command);
                }
            }
        }
        catch (HeadlessException e) {
            if (log.isWarnEnabled()) {
                log.warn("AWT headless exception occurred. {}", (Object)e.toString());
            }
        }
        catch (Exception e) {
            log.error("exception finding action handlers", e);
        }
    }

    public static ActionRouter getInstance() {
        return INSTANCE;
    }
}

