/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.Command;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Command.class})
public class LogLevelCommand
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(LogLevelCommand.class);
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent ev) {
        String levelString = ev.getActionCommand().substring("loglevel:".length());
        log.info("Setting root log level: {}", (Object)levelString);
        Configurator.setRootLevel(Level.toLevel(levelString));
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @API(since="5.3", status=API.Status.INTERNAL)
    public static Level getRootLevel() {
        LoggerContext loggerContext = LoggerContext.getContext(false);
        LoggerConfig loggerConfig = loggerContext.getConfiguration().getRootLogger();
        return loggerConfig.getLevel();
    }

    static {
        for (Level level : Level.values()) {
            commands.add("loglevel:" + level.toString());
        }
    }
}

