/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.jmeter.control.gui.TestFragmentControllerGui;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Command.class})
public class Save
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(Save.class);
    private static final List<File> EMPTY_FILE_LIST = Collections.emptyList();
    private static final String JMX_BACKUP_ON_SAVE = "jmeter.gui.action.save.backup_on_save";
    private static final String JMX_BACKUP_DIRECTORY = "jmeter.gui.action.save.backup_directory";
    private static final String JMX_BACKUP_MAX_HOURS = "jmeter.gui.action.save.keep_backup_max_hours";
    private static final String JMX_BACKUP_MAX_COUNT = "jmeter.gui.action.save.keep_backup_max_count";
    public static final String JMX_FILE_EXTENSION = ".jmx";
    private static final String DEFAULT_BACKUP_DIRECTORY = JMeterUtils.getJMeterHome() + "/backups";
    private static final boolean BACKUP_ENABLED = JMeterUtils.getPropDefault("jmeter.gui.action.save.backup_on_save", true);
    private static final String BACKUP_DIRECTORY = JMeterUtils.getPropDefault("jmeter.gui.action.save.backup_directory", DEFAULT_BACKUP_DIRECTORY);
    private static final int BACKUP_MAX_HOURS = JMeterUtils.getPropDefault("jmeter.gui.action.save.keep_backup_max_hours", 0);
    private static final int BACKUP_MAX_COUNT = JMeterUtils.getPropDefault("jmeter.gui.action.save.keep_backup_max_count", 10);
    private static final DecimalFormat BACKUP_VERSION_FORMATER = new DecimalFormat("000000");
    private static final int MS_PER_HOUR = 3600000;
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doAction(ActionEvent e) throws IllegalUserActionException {
        HashTree subTree;
        JMeterTreeNode[] nodes;
        boolean fullSave = false;
        if (!commands.contains(e.getActionCommand())) {
            throw new IllegalUserActionException("Invalid user command:" + e.getActionCommand());
        }
        if (e.getActionCommand().equals("save_as")) {
            nodes = GuiPackage.getInstance().getTreeListener().getSelectedNodes();
            if (nodes.length > 1) {
                JMeterUtils.reportErrorToUser(JMeterUtils.getResString("save_as_error"), JMeterUtils.getResString("save_as"));
                return;
            }
            subTree = GuiPackage.getInstance().getCurrentSubTree();
        } else if (e.getActionCommand().equals("save_as_test_fragment")) {
            nodes = GuiPackage.getInstance().getTreeListener().getSelectedNodes();
            if (!Save.checkAcceptableForTestFragment(nodes)) {
                JMeterUtils.reportErrorToUser(JMeterUtils.getResString("save_as_test_fragment_error"), JMeterUtils.getResString("save_as_test_fragment"));
                return;
            }
            subTree = Save.createTestFragmentNode(nodes);
        } else {
            fullSave = true;
            subTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
        }
        String updateFile = GuiPackage.getInstance().getTestPlanFile();
        if (!"save".equals(e.getActionCommand()) || updateFile == null) {
            boolean isNewFile = updateFile == null;
            updateFile = Save.computeFileName();
            if (updateFile == null) {
                return;
            }
            if (e.getActionCommand().equals("save_all_as") || isNewFile) {
                GuiPackage.getInstance().setTestPlanFile(updateFile);
            }
        }
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "check_dirty"));
        this.backupAndSave(e, subTree, fullSave, updateFile);
        GuiPackage.getInstance().updateCurrentGui();
    }

    private static HashTree createTestFragmentNode(JMeterTreeNode[] nodes) {
        TestElement element = GuiPackage.getInstance().createTestElement(TestFragmentControllerGui.class.getName());
        ListedHashTree hashTree = new ListedHashTree();
        HashTree tfTree = ((HashTree)hashTree).add(new JMeterTreeNode(element, null));
        for (JMeterTreeNode node : nodes) {
            TreeCloner cloner = new TreeCloner(false);
            GuiPackage.getInstance().getTreeModel().getCurrentSubTree(node).traverse(cloner);
            tfTree.add(cloner.getClonedTree());
        }
        return hashTree;
    }

    private static String computeFileName() {
        int response;
        File f;
        JFileChooser chooser = FileDialoger.promptToSaveFile(GuiPackage.getInstance().getTreeListener().getCurrentNode().getName() + JMX_FILE_EXTENSION);
        if (chooser == null) {
            return null;
        }
        String updateFile = chooser.getSelectedFile().getAbsolutePath();
        if (FilenameUtils.getExtension(updateFile).isEmpty()) {
            updateFile = updateFile + JMX_FILE_EXTENSION;
        }
        if ((f = new File(updateFile)).exists() && ((response = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("save_overwrite_existing_file"), JMeterUtils.getResString("save?"), 0, 3)) == -1 || response == 1)) {
            return null;
        }
        return updateFile;
    }

    void backupAndSave(ActionEvent e, HashTree subTree, boolean fullSave, String newFile) throws IllegalUserActionException {
        List<File> expiredBackupFiles;
        block14: {
            expiredBackupFiles = EMPTY_FILE_LIST;
            if (GuiPackage.getInstance().isDirty()) {
                File fileToBackup = new File(newFile);
                log.debug("Test plan has changed, make backup of {}", (Object)fileToBackup);
                try {
                    expiredBackupFiles = Save.createBackupFile(fileToBackup);
                }
                catch (Exception ex) {
                    log.error("Failed to create a backup for {}", (Object)fileToBackup, (Object)ex);
                }
            }
            try {
                this.convertSubTree(subTree);
            }
            catch (Exception err) {
                if (!log.isWarnEnabled()) break block14;
                log.warn("Error converting subtree. {}", (Object)err.toString());
            }
        }
        try (FileOutputStream ostream = new FileOutputStream(newFile);){
            SaveService.saveTree(subTree, ostream);
            if (fullSave) {
                FileServer.getFileServer().setScriptName(new File(newFile).getName());
                subTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
                ActionRouter.getInstance().doActionNow(new ActionEvent(subTree, e.getID(), "sub_tree_saved"));
            }
            expiredBackupFiles.forEach(FileUtils::deleteQuietly);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error("Error saving tree.", ex);
            throw new IllegalUserActionException("Couldn't save test plan to file: " + newFile, ex);
        }
    }

    private static List<File> createBackupFile(File fileToBackup) {
        if (!BACKUP_ENABLED || !fileToBackup.exists()) {
            return EMPTY_FILE_LIST;
        }
        char versionSeparator = '-';
        String baseName = fileToBackup.getName();
        baseName = baseName.endsWith(JMX_FILE_EXTENSION) ? baseName.substring(0, baseName.length() - JMX_FILE_EXTENSION.length()) : baseName;
        File backupDir = new File(BACKUP_DIRECTORY);
        backupDir.mkdirs();
        if (!backupDir.isDirectory()) {
            log.error("Could not backup file! Backup directory does not exist, is not a directory or could not be created ! <{}>", (Object)backupDir.getAbsolutePath());
            return EMPTY_FILE_LIST;
        }
        String backupPatternRegex = Pattern.quote(baseName + versionSeparator) + "([\\d]{6})" + Pattern.quote(JMX_FILE_EXTENSION);
        Pattern backupPattern = Pattern.compile(backupPatternRegex);
        ArrayList<File> backupFiles = new ArrayList<File>(FileUtils.listFiles(backupDir, new PrivatePatternFileFilter(backupPattern), null));
        backupFiles.sort(LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        int lastVersionNumber = Save.getHighestVersionNumber(backupPattern, backupFiles);
        String backupName = baseName + versionSeparator + BACKUP_VERSION_FORMATER.format((long)lastVersionNumber + 1L) + JMX_FILE_EXTENSION;
        File backupFile = new File(backupDir, backupName);
        try {
            FileUtils.copyFile(fileToBackup, backupFile);
        }
        catch (IOException e) {
            log.error("Failed to backup file: {}", (Object)fileToBackup.getAbsolutePath(), (Object)e);
            return EMPTY_FILE_LIST;
        }
        backupFiles.add(backupFile);
        return Save.backupFilesToDelete(backupFiles);
    }

    private static int getHighestVersionNumber(Pattern backupPattern, List<? extends File> backupFiles) {
        return backupFiles.stream().map(backupFile -> backupPattern.matcher(backupFile.getName())).filter(matcher -> matcher.find() && matcher.groupCount() > 0).mapToInt(matcher -> Integer.parseInt(matcher.group(1))).max().orElse(0);
    }

    private static List<File> backupFilesToDelete(List<? extends File> backupFiles) {
        ArrayList<? extends File> filesToDelete = new ArrayList<File>();
        if (BACKUP_MAX_HOURS > 0) {
            filesToDelete.addAll(Save.expiredBackupFiles(backupFiles));
        }
        if (BACKUP_MAX_COUNT > 0 && backupFiles.size() > BACKUP_MAX_COUNT) {
            filesToDelete.addAll(backupFiles.subList(0, backupFiles.size() - BACKUP_MAX_COUNT));
        }
        return filesToDelete.stream().distinct().collect(Collectors.toList());
    }

    private static List<File> expiredBackupFiles(List<? extends File> backupFiles) {
        if (BACKUP_MAX_HOURS > 0) {
            long expiryMillis = System.currentTimeMillis() - 1L * (long)BACKUP_MAX_HOURS * 3600000L;
            return backupFiles.stream().filter(file -> file.lastModified() < expiryMillis).collect(Collectors.toList());
        }
        return EMPTY_FILE_LIST;
    }

    private static boolean checkAcceptableForTestFragment(JMeterTreeNode[] nodes) {
        return Arrays.stream(nodes).map(DefaultMutableTreeNode::getUserObject).noneMatch(o -> o instanceof AbstractThreadGroup || o instanceof TestPlan);
    }

    void convertSubTree(HashTree tree) {
        for (Object o : new ArrayList<Object>(tree.list())) {
            JMeterTreeNode item = (JMeterTreeNode)o;
            this.convertSubTree(tree.getTree(item));
            TestElement testElement = item.getTestElement();
            tree.replaceKey(item, testElement);
        }
    }

    static {
        commands.add("save_as");
        commands.add("save_as_test_fragment");
        commands.add("save_all_as");
        commands.add("save");
    }

    private static class PrivatePatternFileFilter
    implements IOFileFilter {
        private final Pattern pattern;

        public PrivatePatternFileFilter(Pattern pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException("pattern cannot be null !");
            }
            this.pattern = pattern;
        }

        @Override
        public boolean accept(File dir, String fileName) {
            return this.pattern.matcher(fileName).matches();
        }

        @Override
        public boolean accept(File file) {
            return this.accept(file.getParentFile(), file.getName());
        }
    }
}

