/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.control.TestFragmentController;
import org.apache.jmeter.control.gui.TestFragmentControllerGui;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;

public class JMeterTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 240L;

    @Deprecated
    public JMeterTreeModel(TestElement tp, TestElement wb) {
        this(tp);
    }

    public JMeterTreeModel(TestElement tp) {
        super(new JMeterTreeNode(tp, null));
        this.initTree(tp);
    }

    public JMeterTreeModel() {
        this(new TestPlanGui().createTestElement());
    }

    @Deprecated
    public JMeterTreeModel(Object o) {
        this(new TestPlan());
    }

    public List<JMeterTreeNode> getNodesOfType(Class<?> type) {
        ArrayList<JMeterTreeNode> nodeList = new ArrayList<JMeterTreeNode>();
        JMeterTreeModel.traverseAndFind(type, (JMeterTreeNode)this.getRoot(), nodeList);
        return nodeList;
    }

    public JMeterTreeNode getNodeOf(TestElement userObject) {
        return JMeterTreeModel.traverseAndFind(userObject, (JMeterTreeNode)this.getRoot());
    }

    public HashTree addSubTree(HashTree subTree, JMeterTreeNode current) throws IllegalUserActionException {
        for (Object o : subTree.list()) {
            TestElement item = (TestElement)o;
            if (item instanceof TestPlan) {
                TestPlan tp = (TestPlan)item;
                current = (JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(0);
                TestPlan userObject = (TestPlan)current.getUserObject();
                userObject.addTestElement(item);
                userObject.setName(item.getName());
                userObject.setFunctionalMode(tp.isFunctionalMode());
                userObject.setSerialized(tp.isSerialized());
                this.addSubTree(subTree.getTree(item), current);
                continue;
            }
            if (JMeterTreeModel.isWorkbench(item)) {
                HashTree workbenchTree = subTree.getTree(item);
                if (workbenchTree.isEmpty()) continue;
                this.moveWorkBenchToTestPlan(current, workbenchTree);
                continue;
            }
            this.addSubTree(subTree.getTree(item), this.addComponent(item, current));
        }
        return this.getCurrentSubTree(current);
    }

    private static boolean isWorkbench(TestElement item) {
        return item instanceof WorkBench;
    }

    public JMeterTreeNode addComponent(TestElement component, JMeterTreeNode node) throws IllegalUserActionException {
        if (node.getUserObject() instanceof AbstractConfigGui) {
            throw new IllegalUserActionException("This node cannot hold sub-elements");
        }
        GuiPackage guiPackage = GuiPackage.getInstance();
        if (guiPackage != null) {
            guiPackage.updateCurrentNode();
            JMeterGUIComponent guicomp = guiPackage.getGui(component);
            guicomp.clearGui();
            guicomp.configure(component);
            guicomp.modifyTestElement(component);
            guiPackage.getCurrentGui();
        }
        JMeterTreeNode newNode = new JMeterTreeNode(component, this);
        try {
            newNode.setEnabled(component.isEnabled());
        }
        catch (Exception e) {
            newNode.setEnabled(true);
        }
        this.insertNodeInto(newNode, node, node.getChildCount());
        return newNode;
    }

    public void removeNodeFromParent(JMeterTreeNode node) {
        if (!(node.getUserObject() instanceof TestPlan)) {
            super.removeNodeFromParent(node);
        }
    }

    private static void traverseAndFind(Class<?> type, JMeterTreeNode node, List<? super JMeterTreeNode> nodeList) {
        if (type.isInstance(node.getUserObject())) {
            nodeList.add(node);
        }
        Enumeration<TreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumNode.nextElement();
            JMeterTreeModel.traverseAndFind(type, child, nodeList);
        }
    }

    private static JMeterTreeNode traverseAndFind(TestElement userObject, JMeterTreeNode node) {
        if (userObject == node.getUserObject()) {
            return node;
        }
        Enumeration<TreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumNode.nextElement();
            JMeterTreeNode result = JMeterTreeModel.traverseAndFind(userObject, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public HashTree getCurrentSubTree(JMeterTreeNode node) {
        ListedHashTree hashTree = new ListedHashTree(node);
        Enumeration<TreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumNode.nextElement();
            hashTree.add((Object)node, this.getCurrentSubTree(child));
        }
        return hashTree;
    }

    public HashTree getTestPlan() {
        return this.getCurrentSubTree((JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(0));
    }

    public void clearTestPlan() {
        TestElement tp = new TestPlanGui().createTestElement();
        this.clearTestPlan(tp);
    }

    public void clearTestPlan(TestElement testPlan) {
        int children2 = this.getChildCount(this.getRoot());
        while (children2 > 0) {
            JMeterTreeNode child = (JMeterTreeNode)this.getChild(this.getRoot(), 0);
            super.removeNodeFromParent(child);
            children2 = this.getChildCount(this.getRoot());
        }
        this.initTree(testPlan);
    }

    private void initTree(TestElement tp) {
        this.insertNodeInto(new JMeterTreeNode(tp, this), (JMeterTreeNode)this.getRoot(), 0);
        this.nodeStructureChanged((JMeterTreeNode)this.getRoot());
    }

    private void moveWorkBenchToTestPlan(JMeterTreeNode current, HashTree workbenchTree) throws IllegalUserActionException {
        Object[] workbenchTreeArray = workbenchTree.getArray();
        if (GuiPackage.getInstance() != null) {
            for (Object node : workbenchTreeArray) {
                if (!JMeterTreeModel.isNonTestElement(node)) continue;
                HashTree subtree = workbenchTree.getTree(node);
                workbenchTree.remove(node);
                HashTree tree = new HashTree();
                tree.add(node);
                tree.add(node, subtree);
                ((TestElement)node).setEnabled(false);
                this.addSubTree(tree, current);
            }
        }
        if (!workbenchTree.isEmpty()) {
            HashTree testFragmentTree = new HashTree();
            TestFragmentController testFragmentController = new TestFragmentController();
            testFragmentController.setName("WorkBench Test Fragment");
            testFragmentController.setProperty("TestElement.gui_class", TestFragmentControllerGui.class.getName());
            testFragmentController.setEnabled(false);
            testFragmentTree.add(testFragmentController);
            testFragmentTree.add((Object)testFragmentController, workbenchTree);
            this.addSubTree(testFragmentTree, current);
        }
    }

    private static boolean isNonTestElement(Object node) {
        JMeterTreeNode treeNode = new JMeterTreeNode((TestElement)node, null);
        Collection<String> categories = treeNode.getMenuCategories();
        if (categories != null) {
            for (String category : categories) {
                if (!"menu_non_test_elements".equals(category)) continue;
                return true;
            }
        }
        return false;
    }
}

