/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jmeter.report.core.SampleMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleMetaDataParser {
    private final char separator;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("\\w+((\\W)[\\w ]+)?(\\2[\\w ]+)*(\\2\"[\\w ]+\")*");
    private static final Pattern ALL_WORD_CHARS = Pattern.compile("^\\w+$");

    public SampleMetaDataParser(char separator) {
        this.separator = separator;
    }

    public SampleMetadata parse(String headRow) {
        Matcher matcher;
        char useSep = this.separator;
        if (headRow.indexOf(useSep) < 0 && !ALL_WORD_CHARS.matcher(headRow).matches() && (matcher = DELIMITER_PATTERN.matcher(headRow)).matches()) {
            String guessedSep = matcher.group(2);
            if (guessedSep.length() != 1) {
                throw new IllegalArgumentException("We guessed a delimiter of '" + guessedSep + "', but we support only one-character-separators");
            }
            useSep = guessedSep.charAt(0);
            this.logger.warn("Use guessed delimiter '{}' instead of configured '{}'. Please configure the property 'jmeter.save.saveservice.default_delimiter={}'", Character.valueOf(useSep), Character.valueOf(this.separator), Character.valueOf(useSep));
        }
        String[] cols = headRow.split(Pattern.quote(Character.toString(useSep)));
        return new SampleMetadata(useSep, cols);
    }
}

