/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSummaryConsumer;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.report.utils.MetricUtils;
import org.apache.jmeter.util.JMeterUtils;

public class ErrorsSummaryConsumer
extends AbstractSummaryConsumer<Long> {
    static final boolean ASSERTION_RESULTS_FAILURE_MESSAGE = JMeterUtils.getPropDefault("jmeter.save.saveservice.assertion_results_failure_message", true);
    private static final Long ZERO = 0L;
    private long errorCount = 0L;

    public ErrorsSummaryConsumer() {
        super(false);
    }

    @Override
    protected ListResultData createDataResult(String key, Long data) {
        ListResultData result = new ListResultData();
        result.addResult(new ValueResultData(key != null ? key : JMeterUtils.getResString("reportgenerator_summary_total")));
        result.addResult(new ValueResultData(data));
        result.addResult(new ValueResultData((double)data.longValue() * 100.0 / (double)this.errorCount));
        result.addResult(new ValueResultData((double)data.longValue() * 100.0 / ((Long)this.getOverallInfo().getData()).doubleValue()));
        return result;
    }

    @Override
    protected String getKeyFromSample(Sample sample) {
        return ErrorsSummaryConsumer.getErrorKey(sample);
    }

    static String getErrorKey(Sample sample) {
        if (sample.getSuccess()) {
            return "";
        }
        String responseCode = sample.getResponseCode();
        String responseMessage = sample.getResponseMessage();
        String key = responseCode + (!StringUtils.isEmpty(responseMessage) ? "/" + ErrorsSummaryConsumer.escapeJson(responseMessage) : "");
        if (MetricUtils.isSuccessCode(responseCode) || StringUtils.isEmpty(responseCode) && StringUtils.isNotBlank(sample.getFailureMessage())) {
            String msg;
            key = "Assertion failed";
            if (ASSERTION_RESULTS_FAILURE_MESSAGE && StringUtils.isNotBlank(msg = sample.getFailureMessage())) {
                key = ErrorsSummaryConsumer.escapeJson(msg);
            }
        }
        return key;
    }

    private static String escapeJson(String responseMessage) {
        return new String(JsonStringEncoder.getInstance().quoteAsString(StringEscapeUtils.escapeHtml4(responseMessage)));
    }

    @Override
    protected void updateData(AbstractSummaryConsumer.SummaryInfo info, Sample sample) {
        AbstractSummaryConsumer.SummaryInfo overallInfo = this.getOverallInfo();
        Long overallData = (Long)overallInfo.getData();
        if (overallData == null) {
            overallData = ZERO;
        }
        overallInfo.setData(overallData + 1L);
        if (!sample.getSuccess()) {
            ++this.errorCount;
            Long data = (Long)info.getData();
            if (data == null) {
                data = ZERO;
            }
            info.setData(data + 1L);
        }
    }

    @Override
    public void stopConsuming() {
        super.stopConsuming();
        this.errorCount = 0L;
    }

    @Override
    protected ListResultData createResultTitles() {
        ListResultData titles = new ListResultData();
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_errors_type")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_errors_count")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_errors_rate_error")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_errors_rate_all")));
        return titles;
    }
}

