/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph;

import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.processor.Aggregator;
import org.apache.jmeter.report.processor.AggregatorFactory;

public class SeriesData {
    private final HashMap<Double, Aggregator> aggregators = new HashMap();
    private final Aggregator keysAggregator;
    private final Aggregator valuesAggregator;
    private final boolean isControllersSeries;
    private final boolean isOverallSeries;
    private long count = 0L;

    public final Map<Double, Aggregator> getAggregatorInfo() {
        return this.aggregators;
    }

    public final Aggregator getKeysAggregator() {
        return this.keysAggregator;
    }

    public final Aggregator getValuesAggregator() {
        return this.valuesAggregator;
    }

    public final boolean isControllersSeries() {
        return this.isControllersSeries;
    }

    public final boolean isOverallSeries() {
        return this.isOverallSeries;
    }

    public final long getCount() {
        return this.count;
    }

    public SeriesData(AggregatorFactory factory2, boolean hasAggregatedKey, boolean isControllersSeries, boolean isOverallSeries) {
        if (hasAggregatedKey) {
            this.keysAggregator = factory2.createKeyAggregator();
            this.valuesAggregator = factory2.createAggregatedKeyValueAggregator();
        } else {
            this.keysAggregator = null;
            this.valuesAggregator = null;
        }
        this.isControllersSeries = isControllersSeries;
        this.isOverallSeries = isOverallSeries;
    }

    public void incrementCount() {
        ++this.count;
    }

    public void clear() {
        this.aggregators.clear();
        this.count = 0L;
        if (this.keysAggregator != null) {
            this.keysAggregator.reset();
        }
        if (this.valuesAggregator != null) {
            this.valuesAggregator.reset();
        }
    }
}

