/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStrippingSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_BA = new byte[0];
    private static final Logger log = LoggerFactory.getLogger(DataStrippingSampleSender.class);
    private static final boolean DEFAULT_STRIP_ALSO_ON_ERROR = true;
    private static final boolean SERVER_CONFIGURED_STRIP_ALSO_ON_ERROR = JMeterUtils.getPropDefault("sample_sender_strip_also_on_error", true);
    private final boolean clientConfiguredStripAlsoOnError = JMeterUtils.getPropDefault("sample_sender_strip_also_on_error", true);
    private final RemoteSampleListener listener;
    private final SampleSender decoratedSender;
    private volatile transient boolean stripAlsoOnError;

    @Deprecated
    public DataStrippingSampleSender() {
        log.warn("Constructor only intended for use in testing");
        this.listener = null;
        this.decoratedSender = null;
    }

    DataStrippingSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        this.decoratedSender = null;
        log.info("Using DataStrippingSampleSender for this run");
    }

    DataStrippingSampleSender(SampleSender decorate) {
        this.decoratedSender = decorate;
        this.listener = null;
        log.info("Using DataStrippingSampleSender for this run");
    }

    @Override
    public void testEnded(String host) {
        log.info("Test Ended on {}", (Object)host);
        if (this.decoratedSender != null) {
            this.decoratedSender.testEnded(host);
        }
    }

    @Override
    public void sampleOccurred(SampleEvent event) {
        SampleResult result = event.getResult();
        if (this.stripAlsoOnError || result.isSuccessful()) {
            DataStrippingSampleSender.stripContent(result, 3);
        }
        if (this.decoratedSender == null) {
            try {
                this.listener.sampleOccurred(event);
            }
            catch (RemoteException e) {
                log.error("Error sending sample result over network", e);
            }
        } else {
            this.decoratedSender.sampleOccurred(event);
        }
    }

    private static void stripContent(SampleResult result, int level) {
        if (level < 0) {
            return;
        }
        DataStrippingSampleSender.stripResponse(result);
        for (SampleResult subResult : result.getSubResults()) {
            DataStrippingSampleSender.stripContent(subResult, level - 1);
        }
    }

    private static void stripResponse(SampleResult result) {
        result.setBytes(result.getBytesAsLong());
        result.setResponseData(EMPTY_BA);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.stripAlsoOnError = this.isClientConfigured() ? this.clientConfiguredStripAlsoOnError : SERVER_CONFIGURED_STRIP_ALSO_ON_ERROR;
        log.info("Using DataStrippingSampleSender for this run with stripAlsoOnError: {}", (Object)this.stripAlsoOnError);
        return this;
    }
}

