/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;

public class TextAreaEditor
extends PropertyEditorSupport
implements FocusListener,
PropertyChangeListener {
    private final JSyntaxTextArea textUI;
    private final JTextScrollPane scroller;

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.firePropertyChange();
    }

    private final void init() {
        this.textUI.discardAllEdits();
        this.textUI.addFocusListener(this);
    }

    public TextAreaEditor() {
        this.textUI = JSyntaxTextArea.getInstance(20, 20);
        this.scroller = JTextScrollPane.getInstance(this.textUI, true);
        this.init();
    }

    public TextAreaEditor(Object source2) {
        super(source2);
        this.textUI = JSyntaxTextArea.getInstance(20, 20);
        this.scroller = JTextScrollPane.getInstance(this.textUI, true);
        this.init();
        this.setValue(source2);
    }

    public TextAreaEditor(PropertyDescriptor descriptor) {
        this.textUI = JSyntaxTextArea.getInstance(10, 60);
        this.textUI.setLanguage((String)descriptor.getValue("textLanguage"));
        this.scroller = JTextScrollPane.getInstance(this.textUI, true);
        this.init();
    }

    @Override
    public String getAsText() {
        return this.textUI.getText();
    }

    @Override
    public Component getCustomEditor() {
        return this.scroller;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.textUI.setInitialText(text);
        this.textUI.setCaretPosition(0);
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.textUI.setInitialText(value.toString());
            this.textUI.setCaretPosition(0);
        } else {
            this.textUI.setInitialText("");
        }
    }

    @Override
    public Object getValue() {
        return this.textUI.getText();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source2 = evt.getSource();
        if (source2 instanceof ComboStringEditor) {
            ComboStringEditor cse = (ComboStringEditor)source2;
            String lang = cse.getAsText().toLowerCase(Locale.ROOT);
            this.textUI.setLanguage(lang);
        }
    }
}

