/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.NewDriver;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlanSchema;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPlan
extends AbstractTestElement
implements Serializable,
TestStateListener {
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggerFactory.getLogger(TestPlan.class);
    private static final String CLASSPATH_SEPARATOR = ",";
    private static final String BASEDIR = "basedir";
    private transient List<AbstractThreadGroup> threadGroups = new ArrayList<AbstractThreadGroup>();
    private static volatile boolean functionalMode = false;

    public TestPlan() {
    }

    public TestPlan(String name) {
        this.setName(name);
    }

    @Override
    public TestPlanSchema getSchema() {
        return TestPlanSchema.INSTANCE;
    }

    public PropertiesAccessor<? extends TestPlan, ? extends TestPlanSchema> getProps() {
        return new PropertiesAccessor<TestPlan, TestPlanSchema>(this, this.getSchema());
    }

    protected Object readResolve() {
        this.threadGroups = new ArrayList<AbstractThreadGroup>();
        return this;
    }

    public void prepareForPreCompile() {
        this.getVariables().setRunningVersion(true);
    }

    public boolean isFunctionalMode() {
        return this.get(this.getSchema().getFunctionalMode());
    }

    public void setUserDefinedVariables(Arguments vars) {
        this.set(this.getSchema().getUserDefinedVariables(), vars);
    }

    public JMeterProperty getUserDefinedVariablesAsProperty() {
        return this.getProperty(this.getSchema().getUserDefinedVariables().getName());
    }

    public String getBasedir() {
        return this.getPropertyAsString(BASEDIR);
    }

    public void setBasedir(String b) {
        this.setProperty(BASEDIR, b);
    }

    public Arguments getArguments() {
        return this.getVariables();
    }

    public Map<String, String> getUserDefinedVariables() {
        Arguments args2 = this.getVariables();
        return args2.getArgumentsAsMap();
    }

    private Arguments getVariables() {
        return this.getSchema().getUserDefinedVariables().getOrCreate(this, Arguments::new);
    }

    public void setFunctionalMode(boolean funcMode) {
        this.set(this.getSchema().getFunctionalMode(), funcMode);
        TestPlan.setGlobalFunctionalMode(funcMode);
    }

    private static void setGlobalFunctionalMode(boolean funcMode) {
        functionalMode = funcMode;
    }

    public static boolean getFunctionalMode() {
        return functionalMode;
    }

    public void setSerialized(boolean serializeTGs) {
        this.set(this.getSchema().getSerializeThreadgroups(), serializeTGs);
    }

    public void setTearDownOnShutdown(boolean tearDown) {
        this.set(this.getSchema().getTearDownOnShutdown(), tearDown);
    }

    public boolean isTearDownOnShutdown() {
        return this.get(this.getSchema().getTearDownOnShutdown());
    }

    public void setTestPlanClasspath(String text) {
        this.set(this.getSchema().getTestPlanClasspath(), text);
    }

    public void setTestPlanClasspathArray(String[] text) {
        StringBuilder cat = new StringBuilder();
        for (int idx = 0; idx < text.length; ++idx) {
            if (idx > 0) {
                cat.append(CLASSPATH_SEPARATOR);
            }
            cat.append(text[idx]);
        }
        this.setTestPlanClasspath(cat.toString());
    }

    public String[] getTestPlanClasspathArray() {
        return JOrphanUtils.split(this.getTestPlanClasspath(), CLASSPATH_SEPARATOR);
    }

    public String getTestPlanClasspath() {
        return this.get(this.getSchema().getTestPlanClasspath());
    }

    public boolean isSerialized() {
        return this.get(this.getSchema().getSerializeThreadgroups());
    }

    public void addParameter(String name, String value) {
        this.getVariables().addArgument(name, value);
    }

    @Override
    public void addTestElement(TestElement tg) {
        super.addTestElement(tg);
        if (tg instanceof AbstractThreadGroup && !this.isRunningVersion()) {
            this.addThreadGroup((AbstractThreadGroup)tg);
        }
    }

    public void addThreadGroup(AbstractThreadGroup group) {
        this.threadGroups.add(group);
    }

    @Override
    public void testEnded() {
        try {
            FileServer.getFileServer().closeFiles();
        }
        catch (IOException e) {
            log.error("Problem closing files at end of test", e);
        }
    }

    @Override
    public void testEnded(String host) {
        this.testEnded();
    }

    @Override
    public void testStarted() {
        String[] paths;
        if (this.getBasedir() != null && this.getBasedir().length() > 0) {
            try {
                FileServer.getFileServer().setBasedir(FileServer.getFileServer().getBaseDir() + this.getBasedir());
            }
            catch (IllegalStateException e) {
                log.error("Failed to set file server base dir with {}", (Object)this.getBasedir(), (Object)e);
            }
        }
        for (String path : paths = this.getTestPlanClasspathArray()) {
            try {
                NewDriver.addURL(path);
                log.info("added {} to classpath", (Object)path);
            }
            catch (MalformedURLException e) {
                log.error("Error adding {} to classpath", (Object)path, (Object)e);
            }
        }
    }

    @Override
    public void testStarted(String host) {
        this.testStarted();
    }
}

